<?php
namespace Elementor42\Widgets;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait WooProductMetaStyleTrait {
	/**
	 * Register the style controls
	 */
	private function register_controls_styles(): void {
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', ELEMENTOR42_SLUG ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		// Gap
		$this->add_responsive_control(
			'woo_product_meta__gap__top',
			[
				'label' => __( 'Gaps (Espacements)', ELEMENTOR42_SLUG ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
					'rem' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .product-attributes' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// label style
		$this->add_quick_typography_controls(
			'label',
			'.attr-label',
			'', '',
			__( 'Label', ELEMENTOR42_SLUG )
		);

		// value style
		$this->add_quick_typography_controls(
			'value',
			'.attr-value',
			'', '',
			__( 'Value', ELEMENTOR42_SLUG )
		);

		$this->end_controls_section();
	}
}