<?php
namespace Elementor42\Widgets;;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait TitleContentTrait {

  private function register_controls_content(): void {
    $this->start_controls_section(
      'section_title',
      [
        'label' => __( 'Title', ELEMENTOR42_SLUG ),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    /**
     * Repeater title
     * Can add as many fields as needed
     * Can choose Pre Title, Title, Subtitle
     */
    $titles_repeater = new \Elementor\Repeater();
    $titles_repeater->add_control(
      'text_field',
      [
        'label' => __( 'Texte', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::TEXTAREA,
        'dynamic' => [
          'active' => true,
        ],
        'default' => __( 'Lorem ipsum dolor sit amet', ELEMENTOR42_SLUG ),
        'placeholder' => __( 'Entrez votre titre', ELEMENTOR42_SLUG ),
      ]
    );
    $titles_repeater->add_control(
      'type',
      [
        'label' => __( 'Type', 'a42' ),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'pre_title' => __( 'Pré Titre', ELEMENTOR42_SLUG ),
          'h1' => __( 'Titre H1', ELEMENTOR42_SLUG ),
          'h2' => __( 'Titre H2', ELEMENTOR42_SLUG ),
          'h3' => __( 'Titre H3', ELEMENTOR42_SLUG ),
          'div' => __( 'Div', ELEMENTOR42_SLUG ),
					'span' => __( 'Span', ELEMENTOR42_SLUG ),
          'sub_title' => __('Sous Titre', ELEMENTOR42_SLUG),
        ],
        'default' => 'h2',
      ]
    );

    $titles_repeater->add_control(
      'show_underline',
      [
        'label' => __( 'Souligner', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __( 'Oui', ELEMENTOR42_SLUG ),
        'label_off' => __( 'Non', ELEMENTOR42_SLUG ),
        'return_value' => 'yes',
        'default' => 'yes',
        'condition' => [
          'type' => 'pre_title',
        ],
      ]
    );

    $titles_repeater->add_control(
      'color',
      [
        'label' => __( 'Couleur', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::COLOR,
        'condition' => [
          'type' => ['h1', 'h2', 'h3', 'div', 'span']
        ],
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'titles',
      [
        'label' => __( 'Titres', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::REPEATER,
        'fields' => $titles_repeater->get_controls(),
        'default' => [

          [
            'text_field' => __( 'Pré-titre', ELEMENTOR42_SLUG ),
            'type' => 'pre_title',
          ],
          [
            'text_field' => __( 'Votre titre', ELEMENTOR42_SLUG ),
            'type' => 'h2',
          ],
        ],
        'title_field' => '{{{ text_field }}}',
      ]
    );

    // Alignement
    $this->add_responsive_control(
      'align',
      [
        'label' => __( 'Alignement', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
          'start' => [
            'title' => __( 'Gauche', ELEMENTOR42_SLUG ),
            'icon' => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => __( 'Centre', ELEMENTOR42_SLUG ),
            'icon' => 'eicon-text-align-center',
          ],
          'end' => [
            'title' => __( 'Droite', ELEMENTOR42_SLUG ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'default' => 'left',
        'selectors' => [
          '{{WRAPPER}}' => 'text-align: {{VALUE}};',
          '{{WRAPPER}} .bar' => 'align-self: {{VALUE}};',
          '{{WRAPPER}} .a42-pre_title' => 'align-self: {{VALUE}};',
          '{{WRAPPER}} .a42-title-wrapper:after' => 'align-self: {{VALUE}};',
        ],
      ]
    );

    // Show bar style ?
    $this->add_control(
      'show_bar',
      [
        'label' => __( 'Afficher le trait de séparation', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __( 'Oui', ELEMENTOR42_SLUG ),
        'label_off' => __( 'Non', ELEMENTOR42_SLUG ),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $this->end_controls_section();


  }
}