<?php
namespace Elementor42\Widgets;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait Loop42StyleTrait {

	private function register_controls_styles(): void {
		$this->start_controls_section(
			'section_style_loop42',
			[
				'label' => __( 'Grid', ELEMENTOR42_SLUG ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		// Number of columns to display
		$this->add_responsive_control(
			'columns_number',
			[
				'label' => __( 'Number of columns', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1' => __( '1 column', ELEMENTOR42_SLUG ),
					'2' => __( '2 columns', ELEMENTOR42_SLUG ),
					'3' => __( '3 columns', ELEMENTOR42_SLUG ),
					'4' => __( '4 columns', ELEMENTOR42_SLUG ),
					'5' => __( '5 columns', ELEMENTOR42_SLUG ),
					'6' => __( '6 columns', ELEMENTOR42_SLUG ),
				],
				'default' => '3',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--container' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
				],
			]
		);

		// Gap
		$this->add_responsive_control(
			'loop42__gap__top',
			[
				'label' => __( 'Gaps (Espacements)', ELEMENTOR42_SLUG ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
					'rem' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--container' => 'grid-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Pagination
		$this->start_controls_section(
			'section_style_pagination_loop42',
			[
				'label' => __( 'Pagination', ELEMENTOR42_SLUG ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		// Gap
		$this->add_responsive_control(
			'pagination__gap',
			[
				'label' => __( 'Gaps (Espacements)', ELEMENTOR42_SLUG ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
					'rem' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination .a42-loop42--pagination__nav' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// Alignment
		$this->add_responsive_control(
			'pagination__alignment',
			[
				'label' => __( 'Alignment', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => __( 'Left', ELEMENTOR42_SLUG ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => __( 'Center', ELEMENTOR42_SLUG ),
						'icon' => 'eicon-h-align-center',
					],
					'flex-end' => [
						'title' => __( 'Right', ELEMENTOR42_SLUG ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination' => 'justify-content: {{VALUE}};',
				],
			]
		);

		// Background
		$this->add_control(
			'pagination__background_color',
			[
				'label' => __( 'Background color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pagination__border',
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} .a42-loop42--pagination',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'pagination__border_radius',
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// Padding
		$this->add_responsive_control(
			'pagination__padding',
			[
				'label' => __( 'Padding', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// Padding numbers
		$this->add_responsive_control(
			'pagination__padding_numbers',
			[
				'label' => __( 'Padding', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav .page-numbers' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_pagination_loop42' );
		$this->start_controls_tab(
			'tab_pagination_loop42_normal',
			[
				'label' => __( 'Normal', ELEMENTOR42_SLUG ),
			]
		);

		/** @note Numbers */
		$this->add_quick_typography_controls(
			'pagination__numbers',
			'.a42-loop42--pagination__nav a.page-numbers:not(.next):not(.prev):not(.dots)',
			Global_Colors::COLOR_TEXT,
			Global_Typography::TYPOGRAPHY_PRIMARY,
			__( 'Numbers', ELEMENTOR42_SLUG )
		);

		// Background color
		$this->add_control(
			'pagination__numbers__background_color',
			[
				'label' => __( 'Background color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers:not(.next):not(.prev):not(.dots)' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pagination__numbers__border',
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers:not(.next):not(.prev):not(.dots)',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'pagination__numbers__border_radius',
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers:not(.next):not(.prev):not(.dots)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		/** @note Prev next */
		$this->add_quick_typography_controls(
			'pagination__prev_next',
			'.a42-loop42--pagination__nav a.page-numbers.next, .a42-loop42--pagination__nav a.page-numbers.prev',
			Global_Colors::COLOR_TEXT,
			Global_Typography::TYPOGRAPHY_PRIMARY,
			__( 'Prev next', ELEMENTOR42_SLUG )
		);

		// Background color
		$this->add_control(
			'pagination__prev_next__background_color',
			[
				'label' => __( 'Background color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.next, {{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.prev' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pagination__prev_next__border',
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.next, {{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.prev',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'pagination__prev_next__border_radius',
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.next, {{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		/** @note Dots */
		$this->add_quick_typography_controls(
			'pagination__dots',
			'.a42-loop42--pagination__nav a.page-numbers.dots',
			Global_Colors::COLOR_TEXT,
			Global_Typography::TYPOGRAPHY_PRIMARY,
			__( 'Dots', ELEMENTOR42_SLUG )
		);

		// Background color
		$this->add_control(
			'pagination__dots__background_color',
			[
				'label' => __( 'Background color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.dots' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pagination__dots__border',
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.dots',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'pagination__dots__border_radius',
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.dots' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_pagination_loop42_hover',
			[
				'label' => __( 'Hover', ELEMENTOR42_SLUG ),
			]
		);

		/** @note Numbers */
		$this->add_quick_typography_controls(
			'pagination__numbers__hover',
			'.a42-loop42--pagination__nav a.page-numbers:not(.next):not(.prev):not(.dots):hover',
			Global_Colors::COLOR_TEXT,
			Global_Typography::TYPOGRAPHY_PRIMARY,
			__( 'Numbers', ELEMENTOR42_SLUG )
		);

		// Background color
		$this->add_control(
			'pagination__numbers__background_color__hover',
			[
				'label' => __( 'Background color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers:not(.next):not(.prev):not(.dots):hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pagination__numbers__border__hover',
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers:not(.next):not(.prev):not(.dots):hover',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'pagination__numbers__border_radius__hover',
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers:not(.next):not(.prev):not(.dots):hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		/** @note Prev next */
		$this->add_quick_typography_controls(
			'pagination__prev_next__hover',
			'.a42-loop42--pagination__nav a.page-numbers.next:hover, .a42-loop42--pagination__nav a.page-numbers.prev:hover',
			Global_Colors::COLOR_TEXT,
			Global_Typography::TYPOGRAPHY_PRIMARY,
			__( 'Prev next', ELEMENTOR42_SLUG )
		);

		// Background color
		$this->add_control(
			'pagination__prev_next__background_color__hover',
			[
				'label' => __( 'Background color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.next:hover, {{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.prev:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pagination__prev_next__border__hover',
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.next:hover, {{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.prev:hover',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'pagination__prev_next__border_radius__hover',
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.next:hover, {{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.prev:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		/** @note Dots */
		$this->add_quick_typography_controls(
			'pagination__dots__hover',
			'.a42-loop42--pagination__nav a.page-numbers.dots:hover',
			Global_Colors::COLOR_TEXT,
			Global_Typography::TYPOGRAPHY_PRIMARY,
			__( 'Dots', ELEMENTOR42_SLUG )
		);

		// Background color
		$this->add_control(
			'pagination__dots__background_color__hover',
			[
				'label' => __( 'Background color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.dots:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pagination__dots__border__hover',
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.dots:hover',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'pagination__dots__border_radius__hover',
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav a.page-numbers.dots:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_pagination_loop42_active',
			[
				'label' => __( 'Active', ELEMENTOR42_SLUG ),
			]
		);

		/** @note Numbers */
		$this->add_quick_typography_controls(
			'pagination__numbers__active',
			'.a42-loop42--pagination__nav .page-numbers.current',
			Global_Colors::COLOR_TEXT,
			Global_Typography::TYPOGRAPHY_PRIMARY,
			__( 'Numbers', ELEMENTOR42_SLUG )
		);

		// Background color
		$this->add_control(
			'pagination__numbers__background_color__active',
			[
				'label' => __( 'Background color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav .page-numbers.current' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pagination__numbers__border__active',
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} .a42-loop42--pagination__nav .page-numbers.current',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'pagination__numbers__border_radius__active',
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .a42-loop42--pagination__nav .page-numbers.current' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tabs();

		$this->end_controls_section();
	}
}