<?php
namespace Elementor42\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait Loop42QueryTrait {
	/**
	 * Get the query args
	 */
	private function _getQueryArgs($settings) {
		$paged = get_query_var('paged') ?: 1;

		if ($settings['pagination_page'] !== 0) {
			$paged = $settings['pagination_page'];
		}

		$args = [
			'posts_per_page' => $settings['posts_per_page'],
			'orderby' => $settings['q_orderby'],
			'order' => $settings['q_order'],
			'paged' => $paged,
			'tax_query' => [],
		];

		$post_type = $settings['q_post_type'];

		switch ($post_type) {
			case 'by_id':
				// IF specific posts
				if (!empty($settings['q_posts_ids'])) {
					$args['post__in'] = $settings['q_posts_ids'];
				}
				break;
			case 'current_query':
				// IF current query
				break;
			default:
				$args['post_type'] = $post_type;
				break;
		}

		// Post type
		if ($post_type !== 'by_id') {
			$args['post_type'] = $post_type;
		}

		$term_ids = [];

		if (!empty($settings['q_include_term_ids'])) {
			$term_ids = in_array("-1", $settings['q_include_term_ids']) ? [] : $settings['q_include_term_ids'];
		}

		// Check if ajax include term ids "-1" is set
		if (!empty($settings['ajax_q_include_term_ids'])) {
			$term_ids = in_array("-1", $settings['ajax_q_include_term_ids']) ? [] : $settings['ajax_q_include_term_ids'];
		}
		if (!empty($settings['ajax_q_include_term_ids'])) {
			$term_ids = in_array("-1", $settings['ajax_q_include_term_ids']) ? [] : $settings['ajax_q_include_term_ids'];
		}


		if (!empty($term_ids)) {
			$taxonomy = $post_type === 'product' ? 'product_cat' : 'category';
			$terms = $settings['ajax_q_include_term_ids'] ?? $settings['q_include_term_ids'];
			$args['tax_query'][] = [
				[
					'taxonomy' => $taxonomy,
					'field' => 'term_id',
					'terms' => $term_ids,
				]
			];
		}

		// Filter by EXCLUDE taxonomy
		if (!empty($settings['q_exclude_term_ids'])) {
			$taxonomy = $post_type === 'product' ? 'product_cat' : 'category';
			$args['tax_query'][] = [
				[
					'taxonomy' => $taxonomy,
					'field' => 'term_id',
					'terms' => $settings['q_exclude_term_ids'],
					'operator' => 'NOT IN',
				]
			];
		}

		// Filter by author(s)
		if (!empty($settings['q_include_authors'])) {
			$args['author__in'] = $settings['q_include_authors'];
		}
		
		// Advanced filters
		if (!empty($settings['advanced_filters'])) {
			$args['tax_query'] = [
				'relation' => 'AND',
			];
			$taxs = [];
			foreach ($settings['advanced_filters'] as $tax) {
				$values = [];
				foreach ($tax->value as $value) {
					$values[] = $value;
				}
				$taxs[] = [
					'taxonomy' => $tax->taxonomy,
					'field' => 'term_id',
					'terms' => $values,
					'operator' => 'IN',
				];
			}
			
			$args['tax_query'] = array_merge($args['tax_query'], $taxs);
		}


		return $args;
	}
}