<?php
namespace Elementor42\Widgets;

use ElementorPro\Plugin;
use Elementor42\Utils\BaseWidget;

use Elementor\Controls_Manager;
use Elementor\Core\Base\Document;
use ElementorPro\Modules\LoopBuilder\Documents\Loop as LoopDocument;
use ElementorPro\Modules\LoopBuilder\Files\Css\Loop_Dynamic_CSS;
use ElementorPro\Modules\LoopBuilder\Module;
use ElementorPro\Modules\LoopBuilder\Skins\Skin_Loop_Post;
use ElementorPro\Modules\Posts\Widgets\Posts;
use ElementorPro\Modules\QueryControl\Controls\Template_Query;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Loop42
 *
 * @package Elementor42\Modules\ElementorWidgets
 */
class Loop42 extends BaseWidget {
	use Loop42QueryTrait;
	use Loop42ContentTrait;
	use Loop42StyleTrait;
	use Loop42RenderTrait;

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
    }

	public function get_name(): string {
		return 'a42-loop42';
	}

	public function get_title(): ?string {
		return __( 'A42 Loop', ELEMENTOR42_SLUG );
	}

	public function get_icon(): string {
		return 'eicon-posts-grid';
	}

	public function get_categories(): array {
		return [ 'agency42' ];
	}

	public function get_keywords(): array {
		return [ '42', 'loop', 'posts', 'query' ];
	}

	public function get_style_depends(): array {
		wp_register_style('a42-widget-loop42', ELEMENTOR42_URL . 'assets/css/components/loop42.css', [], ELEMENTOR42_VERSION);
		wp_enqueue_style('a42-widget-loop42');
		return ['anym-utility, a42-widget-loop42'];
	}

	public function get_script_depends(): array {
		wp_register_script('a42-widget-loop42-script', ELEMENTOR42_URL . 'assets/js/components/loop42.js', [], ELEMENTOR42_VERSION, true);
        // Insert ajaxurl
        wp_localize_script('a42-widget-loop42-script', 'a42', [
            'ajaxurl' => admin_url('admin-ajax.php'),
        ]);
        wp_enqueue_script('a42-widget-loop42-script');
		return ['a42-widget-loop42-script'];
	}

	public function register_controls(): void {
        $this->register_controls_content();
		$this->register_controls_styles();
	}
}