<?php
namespace Elementor42\Widgets;

use Elementor\Controls_Manager;
use Elementor42\Utils\BaseWidget;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @Class AdvancedLoopFilter42
 * @package Elementor42\Widgets
 * @since 1.0.0
 */
class AdvancedLoopFilter42 extends BaseWidget {
	public function get_name(): string {
		return 'a42-advanced-loop-filter42';
	}
	
	public function get_title(): ?string {
		return __( 'A42 Advanced Loop Filter', ELEMENTOR42_SLUG );
	}
	
	public function get_icon(): string {
		return 'eicon-posts-grid';
	}
	
	public function get_categories(): array {
		return [ 'agency42' ];
	}
	
	public function get_keywords(): array {
		return [ '42', 'loop', 'posts', 'query', 'filter' ];
	}
	
	public function get_style_depends(): array {
		wp_register_style('a42-widget-advanced-loop-filter42', ELEMENTOR42_URL . 'assets/css/components/advanced-loop-filter42.css', [], ELEMENTOR42_VERSION);
		wp_enqueue_style('a42-widget-advanced-loop-filter42');
		return ['anym-utility, a42-widget-advanced-loop-filter42'];
	}
	
	public function get_script_depends(): array {
		wp_register_script('a42-widget-advanced-loop-filter42-script', ELEMENTOR42_URL . 'assets/js/components/advanced-loop-filter42.js', ['a42-widget-loop42-script'], ELEMENTOR42_VERSION, true);
		// Insert ajaxurl
		wp_localize_script('a42-widget-advanced-loop-filter42-script', 'a42', [
			'ajaxurl' => admin_url('admin-ajax.php'),
		]);
		wp_enqueue_script('a42-widget-advanced-loop-filter42-script');
		return ['a42-widget-advanced-loop-filter42-script'];
	}
	
	public function register_controls(): void {
		$this->start_controls_section(
			'section_content_loop-filter42',
			[
				'label' => __( 'Layout', 'elementor-pro' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		// Add Label
		$this->add_control(
			'filter_label',
			[
				'label' => __( 'Filter Label', 'elementor-pro' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Filtrer par :', 'elementor-pro' ),
				'label_block' => true,
			]
		);
		
		//$loop42_id = $this->get_loop42_widget_id();
		//$widget_settings = $this->get_loop42_settings();
		/*if ( empty( $widget_settings ) ) {
			$this->add_control('notice', [
				'type' => Controls_Manager::RAW_HTML,
				'raw' => '<div class="elementor-panel-alert elementor-panel-alert-warning"><strong>Warning:</strong> Please add a Loop42 widget to the page before adding Advanced Loop filter</div>',
			]);
			$this->end_controls_section();
			return;
		}*/
		$taxonomies = $this->get_taxonomies_for_post_type();
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'tax',
			[
				'label' => __( 'Taxonomie', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'options' => $taxonomies,
				'multiple' => true,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'multiple',
			[
				'label' => esc_html__( 'Multiple', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'textdomain' ),
				'label_off' => esc_html__( 'False', 'textdomain' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'filters_taxonomy',
			[
				'label' => __( 'Taxonomies', 'elementor-pro' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ tax }}}',
				'prevent_empty' => false,
			]
		);
		
		/*$this->add_control(
			'filter_taxonomy',
			[
				'label' => __( 'Taxonomies', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $taxonomies,
				'multiple' => true,
				'label_block' => true,
			]
		);*/
		
		$this->end_controls_section();
	}
	
	public function render(): void {
		$settings = $this->get_settings_for_display();
		$taxonomies = $settings['filters_taxonomy'];
		
		$this->add_render_attribute('_wrapper', [
			'class' => 'a42-advanced-loop-filter42-wrapper',
		]);
		
		echo '<div class="filter-by-label">' . $settings['filter_label'] . '</div>';
		echo '<div class="a42-advanced-loop-filter42-container">';
		foreach ( $taxonomies as $taxonomy ) {
			if ( empty( $taxonomy['tax'] ) ) {
				continue;
			}
			echo $this->render_select( $taxonomy['tax'], $taxonomy['multiple'] );
		}
		echo '</div>';

	}
	
	private function render_select($taxonomy, $multiple): string {
		$taxonomy = get_taxonomy( $taxonomy );
		$multiple = $multiple === 'yes';
		$multipleAttr = $multiple ? ' multiple' : '';
		$label = $taxonomy->label;
		$terms = get_terms( [
			'taxonomy' => $taxonomy->name,
			'hide_empty' => false,
		] );

		$options_html = '';
		if (!$multiple) {
			$options_html = '<option value="">'. $label .'</option>';
		}

		foreach ( $terms as $term ) {
			$options_html .= "<option value='{$term->term_id}'>{$term->name}</option>";
		}
		return <<<HTML
		<div class="a42-advanced-loop-filter42-select elementor-field-type-select">
			<label for="a42-advanced-loop-filter42-select-{$taxonomy->name}">{$label}</label>
			<select id="a42-advanced-loop-filter42-select-{$taxonomy->name}" name="a42-advanced-loop-filter42-select-{$taxonomy->name}" data-taxonomy="{$taxonomy->name}"$multipleAttr>
				$options_html
			</select>
		</div>
HTML;
	}
	
	
	private function get_taxonomies_for_post_type(): array {
		$post_type = $this->get_loop42_post_type();
		
		$taxonomies = get_object_taxonomies( $post_type, 'objects' );
		$taxonomy_options = [];
		foreach ( $taxonomies as $taxonomy ) {
			$taxonomy_options[ $taxonomy->name ] = $taxonomy->label;
		}
		return $taxonomy_options;
	}
	
	private function get_loop42_post_type(): string {
		$loop_settings = $this->get_loop42_settings();
		$post_type = 'post';
		
		if ( ! empty( $loop_settings['q_post_type'] ) ) {
			$post_type = $loop_settings['q_post_type'];
		}
		
		return $post_type;
	}
	
	private function get_loop42_widget_id(): string {
		$widget = $this->get_loop42_widget();
		$widget_id = '';
		if ( ! empty( $widget ) ) {
			$widget_id = $widget[0]['id'];
		}
		
		return $widget_id;
	}
	
	private function get_loop42_widget() {
		$id = get_the_ID();
		$document = \Elementor\Plugin::instance()->documents->get( $id );
		if ( $document ) {
			$element_data = $document->get_elements_data();
			$loop42_widget = $this->find_elements_recursive_by_name( $element_data, 'a42-loop42' );
			return $loop42_widget;
		}
		
		return false;
	}
	
	// Get the a42-loop42 widget settings on the current page
	private function get_loop42_settings(): array {
		$loop42_widget = $this->get_loop42_widget();
		if ( empty( $loop42_widget ) ) {
			return [];
		}
		return $loop42_widget[0]['settings'];
	}
	
	private function find_elements_recursive_by_name($element_data, $name): array {
		$found = [];
		foreach ( $element_data as $element ) {
			if ( !empty($element['widgetType']) && $element['widgetType'] === $name ) {
				$found[] = $element;
			}
			if ( ! empty( $element['elements'] ) ) {
				$found = array_merge( $found, $this->find_elements_recursive_by_name( $element['elements'], $name ) );
			}
		}
		return $found;
	}
	
	private function find_element_recursive_by_name($elements, $name) {
		foreach ( $elements as $element ) {
			if ( !empty($element['widgetType']) && $element['widgetType'] === $name ) {
				return $element;
			}
			if ( ! empty( $element['elements'] ) ) {
				$element = $this->find_element_recursive_by_name( $element['elements'], $name );
				
				if ( $element ) {
					return $element;
				}
			}
		}
		return false;
	}
	
	
}