<?php
namespace Elementor42\Modules\ElementorFormFields;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Form Fields Module
 *
 * @package Elementor42\Modules\ElementorFormFields
 */
class Module {
	public function run(): void {
		// Check if Elementor Pro is active
		if ( !class_exists('\ElementorPro\Modules\Forms\Fields\Field_Base') ) {
			return;
		}
		a42_load_directory(__DIR__);
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_dependencies' ] );
		add_action('elementor_pro/forms/fields/register', [$this, 'register_custom_fields']);
	}

	/**
	 * Register fields
	 *
	 * @param $fields_manager
	 * @return void
	 */
	public function register_custom_fields($fields_manager): void {
		$fields_manager->register(new FieldAdvancedText());
		$fields_manager->register(new FieldCityAutocomplete());
		$fields_manager->register(new FieldAcceptance());
	}

	/*
	 * Enqueue dependencies
	 * @return void
	 */
	public function enqueue_dependencies(): void {
		wp_register_script('a42-field-city-autocomplete-script', ELEMENTOR42_URL . 'assets/js/city-autocomplete.bundle.js');
		wp_localize_script('a42-field-city-autocomplete-script', 'a42', [
			'ajaxurl' => admin_url('admin-ajax.php'),
		]);
		wp_register_style('a42-field-city-autocomplete', ELEMENTOR42_URL . 'assets/css/components/city-autocomplete.css');

		wp_register_script('a42-field-advanced-text-script', ELEMENTOR42_URL . 'assets/js/fields/advanced-text.js');

		wp_register_script('a42-field-acceptance-script', ELEMENTOR42_URL . 'assets/js/fields/acceptance.js');
	}
}

