<?php
namespace Elementor42\Modules\ElementorFormFields;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Class FieldDateSelect
 *
 * @package Elementor42\Modules\ElementorFormFields
 */
class FieldAdvancedText extends \ElementorPro\Modules\Forms\Fields\Field_Base  {
    public $depended_scripts = ['a42-field-advanced-text-script'];

    public $depended_styles = [];

    public function get_type(): string {
        return 'a42-advanced-text';
    }

    public function get_name(): ?string {
        return __( '[A42] Advanced Text', 'elementor-pro' );
    }

    public function render( $item, $item_index, $form ): void {
        $form->add_render_attribute( 'input' . $item_index, [
            'placeholder' => $item['custom_placeholder'],
            'class' => 'elementor-field-textual a42-validation',
        ] );

        if ($item['pattern-name-firstname'] !== 'no') {
            $form->add_render_attribute('input' . $item_index, [
                    'has-pattern' => $item['pattern-name-firstname'],
            ]);
        }

        $bubble = $item['bubble'] ? '
            <div class="a42-bubble">
                <i class="a42-bubble-icon fas fa-question-circle"></i>
               <span class="a42-bubble-desc">'.$item['bubble'].'</span>
            </div>
        ' : '';

        echo strtr(':bubble<input :attributes>', [
            ':bubble' => $bubble,
            ':attributes' => $form->get_render_attribute_string( 'input' . $item_index ),
        ]);
    }

    public function validation( $field, $record, $ajax_handler ): void {
        if ( empty( $field['value'] ) ) {
            return;
        }

	    $form_fields = $record->get_form_settings('form_fields');
        foreach ( $form_fields as $form_field ) {
            if ( $form_field['custom_id'] === $field['id'] ) {
                $name_firstname_field = $form_field;
                break;
            }
        }
        if (!empty($name_firstname_field) && $name_firstname_field !== 'no') {
            switch ($name_firstname_field) {
              case 'name':
                if (preg_match('/^[A-Za-zÀ-ÖØ-öø-ÿ]+([- \'][A-Za-zÀ-ÖØ-öø-ÿ]+)*$/', $field['value']) !== 1) {
                    $ajax_handler->add_error($field['id'], esc_html__('Veuillez entrer un nom valide.', 'elementor-pro'));
                }
                break;
              case 'firstname':
                if (preg_match('/^[A-Za-zÀ-ÖØ-öø-ÿ]+([- \'][A-Za-zÀ-ÖØ-öø-ÿ]+)*$/', $field['value']) !== 1) {
                    $ajax_handler->add_error($field['id'], esc_html__('Veuillez entrer un prénom valide.', 'elementor-pro'));
                }
                break;
              case 'name-firstname':
                if (preg_match('/^[A-Za-zÀ-ÖØ-öø-ÿ]+([- \'][A-Za-zÀ-ÖØ-öø-ÿ]+)* [A-Za-zÀ-ÖØ-öø-ÿ]+([- \'][A-Za-zÀ-ÖØ-öø-ÿ]+)*$/', $field['value']) !== 1) {
                    $ajax_handler->add_error($field['id'], esc_html__('Veuillez entrer un nom et un prénom.', 'elementor-pro'));
                }
                break;
              case 'phone-10digits':
                if (preg_match('/^(?:(?:\+|00)33|0)\s*[1-9](?:[\s.-]*\d{2}){4}$/', $field['value']) !== 1) {
                    $ajax_handler->add_error($field['id'], esc_html__('Veuillez entrer un numéro de téléphone valide.', 'elementor-pro'));
                }
                break;
							case 'email':
								if (filter_var($field['value'], FILTER_VALIDATE_EMAIL) === false) {
									$ajax_handler->add_error($field['id'], esc_html__('Veuillez entrer une adresse email valide.', 'elementor-pro'));
								}
            }
        }
    }

    public function update_controls( $widget ): void {
	    $elementor = \ElementorPro\Plugin::elementor();

        $control_data = $elementor->controls_manager->get_control_from_stack( $widget->get_unique_name(), 'form_fields' );

        if ( is_wp_error( $control_data ) ) {
            return;
        }

        $field_controls = [
            // Custom placeholder control field
            'a42-advanced-text-placeholder' => [
                'name'          => 'custom_placeholder',
                'label'         => esc_html__( 'Placeholder', 'textdomain' ),
                'type'          => \Elementor\Controls_Manager::TEXT,
                'condition' => [
	                'field_type' => $this->get_type(),
                ],
                'tab'           => 'content',
                'inner_tab'     => 'form_fields_content_tab',
                'tabs_wrapper'  => 'form_fields_tabs',
            ],


          // Choose pattern type (select)
          'a42-advanced-text-pattern' => [
            'name' => 'pattern-name-firstname',
            'label' => esc_html__( 'Pattern', ELEMENTOR42_SLUG ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
              'no' => esc_html__( 'Aucun', ELEMENTOR42_SLUG ),
              'name' => esc_html__( 'Nom', ELEMENTOR42_SLUG ),
              'firstname' => esc_html__( 'Prénom', ELEMENTOR42_SLUG ),
              'name-firstname' => esc_html__( 'Nom et prénom', ELEMENTOR42_SLUG ),
              'phone-10digits' => esc_html__( 'Téléphone 10 chiffres', ELEMENTOR42_SLUG ),
	            'email' => esc_html__( 'Email', ELEMENTOR42_SLUG ),
            ],
            'condition' => [
              'field_type' => $this->get_type(),
            ],
            'tab' => 'content',
            'inner_tab' => 'form_fields_content_tab',
            'tabs_wrapper' => 'form_fields_tabs',
          ],
          'advanced-text__a42-bubble' => [
            'name' => 'bubble',
            'label' => esc_html__( 'Bulle d\'aide', ELEMENTOR42_SLUG ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'field_type' => $this->get_type(),
            ],
            'dynamic' => [
	            'active' => true,
            ],
            'tab' => 'content',
            'inner_tab' => 'form_fields_advanced_tab',
            'tabs_wrapper' => 'form_fields_tabs',
          ],
        ];
        $control_data['fields'] = $this->inject_field_controls( $control_data['fields'], $field_controls );
        $widget->update_control( 'form_fields', $control_data );
    }
}