<?php
namespace Elementor42\Modules\ElementorFormActions;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use ElementorPro\Modules\Forms\Classes\Ajax_Handler;
use ElementorPro\Modules\Forms\Classes\Form_Record;
use ElementorPro\Modules\Popup\Document;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;
use ElementorPro\Modules\Forms\Module as FormsModule;
use ElementorPro\Modules\Popup\Module as PopupModule;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Class ActionCallback
 *
 * @package Elementor42\Modules\ElementorFormActions
 */
class ActionPopup extends \ElementorPro\Modules\Forms\Classes\Action_Base {

  public function __construct() {
	  /** @var FormsModule $forms_module */
	  $forms_module = FormsModule::instance();

	  // Register popup form action
	  $forms_module->actions_registrar->register( $this );
	  add_action( 'elementor-pro/forms/pre_render', [ $this, 'maybe_print_popup' ], 10, 2 );
  }

  /**
   * Get name
   *
   * @return string
   */
  public function get_name(): string {
    return 'a42-popup';
  }

  /**
   * Get label
   *
   * @return string
   */
  public function get_label(): string {
    return '[a42] Pop up';
  }

  /**
   * Register action controls
   *
   * Input fields :
   * - url
   *
   * @param Widget_Base $widget
   */
  public function register_settings_section($widget): void {

    $widget->start_controls_section(
      'section_a42popup',
      [
        'label' => $this->get_label(),
        'condition' => [
          'submit_actions' => $this->get_name(),
        ],
      ]
    );

	  $widget->add_control(
		  'a42_popup_action_popup_id',
		  [
			  'label' => esc_html__( 'Popup', 'elementor-pro' ),
			  'type' => QueryControlModule::QUERY_CONTROL_ID,
			  'label_block' => true,
			  'autocomplete' => [
				  'object' => QueryControlModule::QUERY_OBJECT_LIBRARY_TEMPLATE,
				  'query' => [
					  'posts_per_page' => 20,
					  'meta_query' => [
						  [
							  'key' => Document::TYPE_META_KEY,
							  'value' => 'popup',
						  ],
					  ],
				  ],
			  ],
		  ]
	  );

    // Textarea control
	  $widget->add_control(
			'a42_thankyou_message',
			[
				'label' => __( 'Message', 'elementor' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Thank you for your submission', 'elementor' ),
			]
	  );

    $widget->end_controls_section();
  }

  /**
   * Run action
   * Open modal
   *
   * @param Form_Record $record
   * @param Ajax_Handler $ajax_handler
   * @return void
   */
  public function run( $record, $ajax_handler ): void {
		$popup_id = $record->get_form_settings( 'a42_popup_action_popup_id' );

		if ( empty( $popup_id ) ) {
			return;
		}

		$action_settings = [
			'action' => 'open',
			'id' => $popup_id,
		];

		$ajax_handler->add_response_data( 'a42_popup', $action_settings );
  }

  /**
   * On export
   * @param array $element
   * @return array
   */
  public function on_export( $element ): array {
		unset(
			$element['settings']['a42_popup_action_popup_id'],
			$element['settings']['a42_thankyou_message']
		);
    return $element;
  }

	public function maybe_print_popup( $settings, $widget ) {

		$has_valid_settings = ( ! empty( $settings['a42_popup_action_popup_id'] ) );
		if ( ! $has_valid_settings ) {
			return;
		}

		PopupModule::add_popup_to_location( $settings['a42_popup_action_popup_id'] );
	}
}