<?php
namespace Elementor42\Modules\ElementorFormActions;

use Elementor\Widget_Base;
use ElementorPro\Modules\Forms\Classes\Ajax_Handler;
use ElementorPro\Modules\Forms\Classes\Form_Record;
use ElementorPro\Modules\Forms\Module as FormsModule;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class ActionDataContent
 *
 * @package Elementor42\Modules\ElementorFormActions
 */
class ActionDataContent extends \ElementorPro\Modules\Forms\Classes\Action_Base {

	public function __construct() {
		/** @var FormsModule $forms_module */
		$forms_module = FormsModule::instance();

		// Register popup form action
		$forms_module->actions_registrar->register( $this );
	}

	/**
	 * Get name
	 *
	 * @return string
	 */
	public function get_name(): string {
		return 'a42-data-content';
	}

	/**
	 * Get label
	 *
	 * @return string
	 */
	public function get_label(): string {
		return '[a42] Retour de formulaire';
	}

	/**
	 * Register action controls
	 *
	 * Input fields :
	 * - url
	 *
	 * @param Widget_Base $widget
	 */
	public function register_settings_section($widget): void {

		$widget->start_controls_section(
			'section_' . $this->get_name(),
			[
				'label' => $this->get_label(),
				'condition' => [
					'submit_actions' => $this->get_name(),
				],
			]
		);

		$widget->add_control(
			'desc_' . $this->get_name(),
			[
				'raw' => __( '
				Grâce à cette action, vous pouvez récupérer les données de chaque champs du formulaire reçu par le serveur dans l\'objet de réponse :<br>
				Il faut utiliser l\'event <br>
				<code>elementorFrontend.elements.$document.on(\'submit_success\', function (event, response) {});</code> <br>
				pour récupérer les données.<br>
				Ou bien utiliser le contenu dynamique "Réponse du formulaire" et insérer l\'id du champ souhaité<br>
          ', ELEMENTOR42_SLUG),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'content_classes' => 'elementor-descriptor',
			]
		);

		$widget->end_controls_section();
	}

	/**
	 * Run action
	 * Open modal
	 *
	 * @param Form_Record $record
	 * @param Ajax_Handler $ajax_handler
	 * @return void
	 */
	public function run( $record, $ajax_handler ): void {

		$raw_fields = $record->get( 'fields' );
		$data = [];
		foreach ( $raw_fields as $id => $field ) {
			// Allow to modify the field value before adding it to the data
			$data[$id] = apply_filters('a42/forms/record/actions/data_content/field', $field['value'], $id, $field);
		}

		// Allow to modify the data before sending it to the frontend
		$data = apply_filters('a42/forms/record/actions/data_content', $data, $record);

		$ajax_handler->add_response_data( 'a42_data', $data );
	}

	/**
	 * On export
	 * @param array $element
	 * @return array
	 */
	public function on_export( $element ): array {
		return $element;
	}
}