<?php
namespace Elementor42\Modules\ElementorDynamicTags;

use Elementor\Controls_Manager;
use Elementor\Modules\DynamicTags\Module as DTagsModule;
use ElementorPro\Modules\DynamicTags\Tags;
use ElementorPro\Modules\DynamicTags\Tags\Base\Data_Tag;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class TagFormAction
 *
 * @package Elementor42\Modules\ElementorDynamicTags
 */
class TagFormAction extends Data_Tag {

	public function get_name(): string {
		return 'a42-form-action';
	}

	public function get_title(): string {
		return esc_html__( '[a42] Réponse de formulaire', ELEMENTOR42_SLUG);
	}

	public function get_group(): array {
		return ['action'];
	}

	public function get_categories(): array {
		return [
			DTagsModule::TEXT_CATEGORY,
			DTagsModule::URL_CATEGORY,
			DTagsModule::DATETIME_CATEGORY,
			DTagsModule::NUMBER_CATEGORY,
			DTagsModule::IMAGE_CATEGORY,
			DTagsModule::POST_META_CATEGORY,
		];
	}

	protected function register_controls(): void {

		// Before
		$this->add_control(
			'before',
			[
				'label' => esc_html__( 'Before', 'elementor-pro' ),
				'type' => Controls_Manager::TEXT,
				'default' => '',
			]
		);

		// After
		$this->add_control(
			'after',
			[
				'label' => esc_html__( 'After', 'elementor-pro' ),
				'type' => Controls_Manager::TEXT,
				'default' => '',
			]
		);

		// Field id to get the value from
		$this->add_control(
			'field_id',
			[
				'label' => esc_html__( 'Field ID', 'elementor-pro' ),
				'type' => Controls_Manager::TEXT,
				'default' => '',
			]
		);

		$this->add_control(
			'fallback',
			[
				'label' => esc_html__( 'Fallback', 'elementor-pro' ),
				'type' => Controls_Manager::TEXT,
				'default' => '',
			]
		);
	}

	/**
	 * The value of the tag is dynamically
	 * hydrated in from the form submission data response
	 *
	 * @param array $options
	 *
	 * @return string
	 */
	protected function get_value( array $options = [] ): string {
		$field_id = $this->get_settings( 'field_id' );
		$fallback = $this->get_settings( 'fallback' );
		$before = $this->get_settings( 'before' );
		$after = $this->get_settings( 'after' );

		$html = strtr('<span class="a42-form-action" data-before="{before}" data-after="{after}" data-field-id="{field_id}" data-fallback="{fallback}"></span>', [
			'{field_id}' => $field_id,
			'{fallback}' => $fallback,
			'{before}' => $before,
			'{after}' => $after,
		]);
		return $html;
	}
}