<?php
namespace Elementor42\Includes;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class ComponentModifier
 *
 * Register all assets and load them to elementor widgets
 * @package ThanksForLeads\Includes
 */
class ComponentModifier {

  public array $widget_assets_css = [];
  public array $widget_assets_js = [
	  /*[
		  'filename' => 'form',
		  'deps' => ['jquery']
	  ]*/
  ];

  public string $path_css = ELEMENTOR42_ASSETS . '/css/customized-widgets/';
  public string $path_js = ELEMENTOR42_ASSETS . '/js/customized-widgets/';

  public function __construct() {
    add_action('elementor/frontend/before_enqueue_styles', [$this, 'register']);
    add_action('elementor/widget/before_render_content', [$this, 'load_assets']);

		a42_load_directory(__DIR__);
		new namespace\ComponentModifiers\Form();
  }

  /**
   * Register all styles
   * @return void
   */
  public function register(): void {
    foreach ($this->widget_assets_css as $widget) {
      wp_register_style('tfl-' . $widget['filename'], $this->path_css . $widget['filename'] . '.css', $widget['deps'] ?? [], ELEMENTOR42_VERSION);
    }
	foreach ($this->widget_assets_js as $widget) {
		wp_register_script('tfl-' . $widget['filename'], $this->path_js . $widget['filename'] . '.js', $widget['deps'] ?? [], ELEMENTOR42_VERSION, true);
	}
  }

  /**
   * Load assets to widget
   * @param $widget
   * @return void
   */
  public function load_assets($widget): void {
    //echo $widget->get_name();
		foreach ($this->widget_assets_css as $widget_css) {
		  if ($widget_css['filename'] === $widget->get_name()) {
			wp_enqueue_style('tfl-' . $widget->get_name());
		  }
		}

		foreach ($this->widget_assets_js as $widget_js) {
			if ($widget_js['filename'] === $widget->get_name()) {
				wp_enqueue_script('tfl-' . $widget->get_name());
			}
		}
  }
}