<?php
namespace Elementor42\Widgets;

use Elementor42\Utils\BaseWidget;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Title
 *
 * @package Elementor42\Modules\ElementorWidgets
 */
class Cta extends BaseWidget {

  use CtaContentTrait;
  use CtaStyleTrait;
  use CtaRenderTrait;

  public function get_name(): string {
    return 'a42-cta';
  }

  public function get_title(): ?string {
    return __( 'A42 Cta', ELEMENTOR42_SLUG );
  }

  public function get_icon(): string {
    return 'eicon-image-rollover';
  }

  public function get_categories(): array {
    return [ 'agency42' ];
  }

  public function get_keywords(): array {
    return [ '42', 'title', 'text', 'heading' ];
  }

  public function get_style_depends(): array {
    wp_register_style('a42-widget-cta', ELEMENTOR42_URL . 'assets/css/components/cta.css', [], ELEMENTOR42_VERSION);
    wp_enqueue_style('a42-widget-cta');
    return ['anym-utility, a42-widget-cta'];
  }

  public function get_script_depends(): array {
    return [];
  }

  public function register_controls(): void {
    $this->register_controls_content();
    $this->register_controls_styles();
  }
}