

class AdvancedText {

    namePattern = /^[A-Za-zÀ-ÖØ-öø-ÿ]+([- \'][A-Za-zÀ-ÖØ-öø-ÿ]+)*$/;
    firstNamePattern = /^[A-Za-zÀ-ÖØ-öø-ÿ]+([- \'][A-Za-zÀ-ÖØ-öø-ÿ]+)*$/;
    nameFirstNamePattern = /^[A-Za-zÀ-ÖØ-öø-ÿ]+([- \'][A-Za-zÀ-ÖØ-öø-ÿ]+)* [A-Za-zÀ-ÖØ-öø-ÿ]+([- \'][A-Za-zÀ-ÖØ-öø-ÿ]+)*$/;
    //phone10DigitsPattern = /^[0-9]{10}$/;
    // Allow +33, 0033, 0 etc
    phone10DigitsPattern = /^(?:(?:\+|00)33|0)\s*[1-9](?:[\s.-]*\d{2}){4}$/;
    emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;

    errorMessages = {
        valueMissing: 'Ce champ est obligatoire',
        pattern: {
            name: 'Veuillez entrer un nom valide',
            firstname: 'Veuillez entrer un prénom valide',
            'name-firstname' : 'Veuillez entrer un nom et un prénom valides',
            'phone-10digits': 'Veuillez entrer un numéro de téléphone à 10 chiffres valide',
            email: 'Veuillez entrer une adresse email valide'
        }
    }

    pristine = true;

    constructor(element) {
        this.element = element;
        this.element.AdvancedText = this;
        this.validationElement = this.element;
        if (this.validationElement == null) {
            return;
        }
        this.init();
    }

    init() {
        this.validationElement.getValidity = this.getValidity.bind(this);
        this.checkPattern();

        // on focusout
        this.element.addEventListener('focusout', _ => {
            this.pristine = false;
            this.element.dispatchEvent(new Event('validate'));
        });

        this.element.addEventListener('input', _ => {
            if (this.validationElement.error != null && !this.pristine) {
                this.element.dispatchEvent(new Event('validate'));
            }
        });
    }

    getValidity() {
        const isFieldRequired = this.element.getAttribute('required') != null;
        const namePattern = this.element.getAttribute('has-pattern');



        if (!isFieldRequired && this.element.value === '') {
            this.validationElement.error = '';
            return true;
        }

        if (!!isFieldRequired && this.element.value === '') {
            this.validationElement.error = this.errorMessages.valueMissing;
            return false;
        }

        if (namePattern != null && namePattern !== 'no') {
            return this.testPattern(isFieldRequired);
        }

        return true;
    }

    testPattern(isFieldRequired = false) {
        let isValid = true;
        if (!isFieldRequired && this.element.value === '') {
            return true;
        }
        const namePattern = this.element.getAttribute('has-pattern');
        if (namePattern != null && namePattern !== 'no') {
            switch (namePattern) {
                case 'name':
                    isValid = this.element.value.match(this.namePattern);
                    break;
                case 'firstname':
                    isValid = this.element.value.match(this.firstNamePattern);
                    break;
                case 'name-firstname':
                    isValid = this.element.value.match(this.nameFirstNamePattern);
                    break;
                case 'phone-10digits':
                    isValid = this.element.value.match(this.phone10DigitsPattern);
                    break;
                case 'email':
                    isValid = this.element.value.match(this.emailPattern);
                    break;

            }
        }
        if (!isValid && namePattern != null && namePattern !== 'no') {
            this.element.error = this.errorMessages.pattern[namePattern];
        }
        return isValid;
    }


    /**
     * Check if input has good pattern
     */

    checkPattern() {
        const namePattern = this.element.getAttribute('has-pattern');
        if (namePattern != null) {
            this.element.addEventListener('input', _ => {
                if (!this.testPattern()) {
                    this.element.error = this.errorMessages.pattern[namePattern];
                }
            });
        }
    }
}

window.addEventListener('elementor/frontend/init', () => {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', function($scope) {
        $scope.find('input[type="a42-advanced-text"]').each(function() {
            if(this.AdvancedText) return;
            new AdvancedText(this);
        });

    });
});