/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./assets/js/fields/city-autocomplete.js":
/*!***********************************************!*\
  !*** ./assets/js/fields/city-autocomplete.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _tarekraafat_autocomplete_js_dist_autoComplete__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tarekraafat/autocomplete.js/dist/autoComplete */ \"./node_modules/@tarekraafat/autocomplete.js/dist/autoComplete.js\");\n/* harmony import */ var _tarekraafat_autocomplete_js_dist_autoComplete__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tarekraafat_autocomplete_js_dist_autoComplete__WEBPACK_IMPORTED_MODULE_0__);\n\n/**\n * The list of cities\n * @type {[] | undefined}\n */\nlet cities = undefined;\nlet loading = false;\n/**\n * CityAutocomplete component\n */\nclass CityAutocomplete {\n\n    /**\n     * The input element\n     * @type {string}\n     */\n    ajaxUrl = '';\n\n    /**\n     * The autocomplete instance\n     * @type {undefined | AutoComplete}\n     */\n    autocomplete = undefined;\n\n    /**\n     * The input text\n     * @type {string}\n     */\n    currentText = '';\n\n    /**\n     * Initialized?\n     * @type {boolean}\n     */\n    initialized = false;\n\n    /**\n     * @constructor\n     * @param element {HTMLElement} The button element\n     */\n    constructor(element) {\n        this.element = element;\n        this.ajaxUrl = window.a42?.ajaxurl;\n        this.validationElement = this.element;\n        this.init();\n    }\n\n    init() {\n        this.validationElement.getValidity = this.getValidity.bind(this);\n        this.element.addEventListener('focus', async () => {\n            if (cities == null && !loading && !this.initialized) {\n                loading = true;\n                const data = await this._fetchData();\n                if (data.success === true) {\n                    cities = data.data;\n                    this.initAutoComplete();\n                    this.element.focus();\n\n                } else {\n                    console.error('Error fetching cities data');\n                    loading = false;\n                }\n            } else if (!this.initialized) {\n                this.initAutoComplete()\n                this.element.focus();\n            } else {\n                this.element.focus();\n                this.autocomplete.open();\n            }\n        });\n\n        // Focus out\n        this.element.addEventListener('focusout', () => {\n            if (!this.initialized) {\n                return;\n            }\n            this.element.dispatchEvent(new Event('validate'));\n        });\n    }\n\n    getValidity() {\n        const isFieldRequired = this.element.getAttribute('required') != null;\n\n        let isValid = true;\n\n        if (!isFieldRequired && this.element.value === '') {\n            return true;\n        }\n\n        if (isFieldRequired) {\n            isValid = this.element.value !== '';\n            if (!isValid) {\n                this.validationElement.error = 'Veuillez sélectionner une ville';\n            } else {\n                this.validationElement.error = '';\n            }\n        }\n\n        // Check if the value is in the list\n        if (isValid) {\n            const value = this.element.value;\n            if (!cities.includes(value)) {\n                isValid = false;\n                this.validationElement.error = 'Veuillez sélectionner une ville parmi la liste';\n            } else {\n                this.validationElement.error = '';\n            }\n        }\n\n        return isValid;\n    }\n\n    /**\n     * Format the string to ignore spaces and special characters\n     * @param str\n     * @returns {string}\n     */\n    _formatString(str) {\n        // Replace all special characters and spaces êàèé -> eae\n        str = str.normalize('NFD').replace(/[\\u0300-\\u036f]/g, \"\");\n        return str.toLowerCase().replace(/[^a-zA-Z0-9]/g, '');\n    }\n\n    /**\n     * Matches the query with the record\n     *\n     * The record is formatted as : \"12345, City Name\"\n     * The query will match if the postal code is found before or after the city name\n     * @param query {string} The query string\n     * @param record {string} The record string\n     * @returns {boolean}\n     */\n    _matches(query, record) {\n        const recordPostCode = this._formatString(record.split(',')[0]);\n        const recordCity = this._formatString(record.split(',')[1]);\n        const q = this._formatString(query);\n        // Get all characters from the query\n        const qPostCodes = this._formatString(q.match(/\\d/g)?.join('') ?? '');\n        const qCities = this._formatString(q.match(/[a-zA-Z]/g)?.join('') ?? '');\n        // Get all characters from the record\n        if (qPostCodes != null && qCities != null) {\n            // Check if all characters from the query are in the record\n            return recordPostCode.includes(qPostCodes) && recordCity.includes(qCities);\n        } else if (qPostCodes != null) {\n            return recordPostCode.includes(qPostCodes);\n        } else if (qCities != null) {\n            return recordCity.includes(qCities);\n        } else {\n            return false;\n        }\n    }\n\n    /**\n     * Search engine\n     * @param query\n     * @return {Promise<T[]>}\n     */\n    async searchEngine(query) {\n        const q = this._formatString(query);\n\n        const filteredCities = cities.filter(city => {\n            return this._matches(query, city);\n        });\n\n        return filteredCities.sort((a, b) => {\n            const aIndex = this._formatString(a).indexOf(q);\n            const bIndex = this._formatString(b).indexOf(q);\n            if (aIndex === bIndex) {\n                return a.localeCompare(b);\n            }\n            return aIndex - bIndex;\n        });\n\n    }\n\n    /**\n     * Initialize the Autocomplete\n     */\n    initAutoComplete() {\n        this.autocomplete = new (_tarekraafat_autocomplete_js_dist_autoComplete__WEBPACK_IMPORTED_MODULE_0___default())({\n            data: {\n                src: query => this.searchEngine(query),\n                cache: false,\n            },\n            /**\n             * Render the results\n             *\n             * Strategy:\n             * 1. 2 Firsts letters must match\n             * 2. Need at least 2 letters\n             * 3. Case-insensitive\n             *\n             * @param query\n             * @param record\n             * @return {*}\n             */\n            searchEngine: (query, record) => {\n                //console.log('record:', record)\n                return record;\n            },\n            resultsList: {\n                maxResults: 15,\n                class: \"a42-autocomplete-results\",\n            },\n            threshold: 2,\n            selector: () => {\n                return this.element;\n            },\n            events: {\n                input: {\n                    selection: (event) => {\n                        const selection = event.detail.selection.value;\n                        this.autocomplete.input.value = selection;\n                        this.element.dispatchEvent(new Event('validate'));\n                    },\n                    results: (event) => {\n\n                        //console.log('results:', event)\n\n                        if (event.detail.results.length === 0) {\n                            //this.errorBox.innerText = \"Aucune ville ne correspond à votre recherche\";\n                        }\n                    },\n                    close: (event) => {\n                        //this.errorBox.style.display = \"block\";\n                        //this.element.dispatchEvent(new Event('validate'));\n                    },\n                    open: (event) => {\n                        //this.errorBox.style.display = \"none\";\n                    },\n                },\n            },\n        });\n        this.initialized = true;\n    }\n\n    /**\n     * Fetch data from the server\n     * @returns {Promise<unknown>}\n     */\n    _fetchData() {\n        return new Promise((resolve, reject) => {\n            const formData = new FormData();\n            formData.append('action', 'a42_city_autocomplete');\n\n            fetch(this.ajaxUrl, {\n                method: 'POST',\n                body: formData,\n            }).then(response => response.json())\n                .then(body => {\n                    resolve(body);\n                }\n            );\n        });\n    }\n}\n\n\ndocument.querySelectorAll(\"input[type='a42-city-autocomplete']\").forEach(element => {\n    new CityAutocomplete(element);\n});\n\n//# sourceURL=webpack:///./assets/js/fields/city-autocomplete.js?");

/***/ }),

/***/ "./node_modules/@tarekraafat/autocomplete.js/dist/autoComplete.js":
/*!************************************************************************!*\
  !*** ./node_modules/@tarekraafat/autocomplete.js/dist/autoComplete.js ***!
  \************************************************************************/
/***/ (function(module) {

eval("(function (global, factory) {\n   true ? module.exports = factory() :\n  0;\n})(this, (function () { 'use strict';\n\n  function ownKeys(object, enumerableOnly) {\n    var keys = Object.keys(object);\n\n    if (Object.getOwnPropertySymbols) {\n      var symbols = Object.getOwnPropertySymbols(object);\n      enumerableOnly && (symbols = symbols.filter(function (sym) {\n        return Object.getOwnPropertyDescriptor(object, sym).enumerable;\n      })), keys.push.apply(keys, symbols);\n    }\n\n    return keys;\n  }\n\n  function _objectSpread2(target) {\n    for (var i = 1; i < arguments.length; i++) {\n      var source = null != arguments[i] ? arguments[i] : {};\n      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {\n        _defineProperty(target, key, source[key]);\n      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {\n        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));\n      });\n    }\n\n    return target;\n  }\n\n  function _typeof(obj) {\n    \"@babel/helpers - typeof\";\n\n    return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) {\n      return typeof obj;\n    } : function (obj) {\n      return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj;\n    }, _typeof(obj);\n  }\n\n  function _defineProperty(obj, key, value) {\n    if (key in obj) {\n      Object.defineProperty(obj, key, {\n        value: value,\n        enumerable: true,\n        configurable: true,\n        writable: true\n      });\n    } else {\n      obj[key] = value;\n    }\n\n    return obj;\n  }\n\n  function _toConsumableArray(arr) {\n    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();\n  }\n\n  function _arrayWithoutHoles(arr) {\n    if (Array.isArray(arr)) return _arrayLikeToArray(arr);\n  }\n\n  function _iterableToArray(iter) {\n    if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter);\n  }\n\n  function _unsupportedIterableToArray(o, minLen) {\n    if (!o) return;\n    if (typeof o === \"string\") return _arrayLikeToArray(o, minLen);\n    var n = Object.prototype.toString.call(o).slice(8, -1);\n    if (n === \"Object\" && o.constructor) n = o.constructor.name;\n    if (n === \"Map\" || n === \"Set\") return Array.from(o);\n    if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);\n  }\n\n  function _arrayLikeToArray(arr, len) {\n    if (len == null || len > arr.length) len = arr.length;\n\n    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];\n\n    return arr2;\n  }\n\n  function _nonIterableSpread() {\n    throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\");\n  }\n\n  function _createForOfIteratorHelper(o, allowArrayLike) {\n    var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"];\n\n    if (!it) {\n      if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") {\n        if (it) o = it;\n        var i = 0;\n\n        var F = function () {};\n\n        return {\n          s: F,\n          n: function () {\n            if (i >= o.length) return {\n              done: true\n            };\n            return {\n              done: false,\n              value: o[i++]\n            };\n          },\n          e: function (e) {\n            throw e;\n          },\n          f: F\n        };\n      }\n\n      throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\");\n    }\n\n    var normalCompletion = true,\n        didErr = false,\n        err;\n    return {\n      s: function () {\n        it = it.call(o);\n      },\n      n: function () {\n        var step = it.next();\n        normalCompletion = step.done;\n        return step;\n      },\n      e: function (e) {\n        didErr = true;\n        err = e;\n      },\n      f: function () {\n        try {\n          if (!normalCompletion && it.return != null) it.return();\n        } finally {\n          if (didErr) throw err;\n        }\n      }\n    };\n  }\n\n  var select$1 = function select(element) {\n    return typeof element === \"string\" ? document.querySelector(element) : element();\n  };\n  var create = function create(tag, options) {\n    var el = typeof tag === \"string\" ? document.createElement(tag) : tag;\n    for (var key in options) {\n      var val = options[key];\n      if (key === \"inside\") {\n        val.append(el);\n      } else if (key === \"dest\") {\n        select$1(val[0]).insertAdjacentElement(val[1], el);\n      } else if (key === \"around\") {\n        var ref = val;\n        ref.parentNode.insertBefore(el, ref);\n        el.append(ref);\n        if (ref.getAttribute(\"autofocus\") != null) ref.focus();\n      } else if (key in el) {\n        el[key] = val;\n      } else {\n        el.setAttribute(key, val);\n      }\n    }\n    return el;\n  };\n  var getQuery = function getQuery(field) {\n    return field instanceof HTMLInputElement || field instanceof HTMLTextAreaElement ? field.value : field.innerHTML;\n  };\n  var format = function format(value, diacritics) {\n    value = String(value).toLowerCase();\n    return diacritics ? value.normalize(\"NFD\").replace(/[\\u0300-\\u036f]/g, \"\").normalize(\"NFC\") : value;\n  };\n  var debounce = function debounce(callback, duration) {\n    var timer;\n    return function () {\n      clearTimeout(timer);\n      timer = setTimeout(function () {\n        return callback();\n      }, duration);\n    };\n  };\n  var checkTrigger = function checkTrigger(query, condition, threshold) {\n    return condition ? condition(query) : query.length >= threshold;\n  };\n  var mark = function mark(value, cls) {\n    return create(\"mark\", _objectSpread2({\n      innerHTML: value\n    }, typeof cls === \"string\" && {\n      \"class\": cls\n    })).outerHTML;\n  };\n\n  var configure = (function (ctx) {\n    var name = ctx.name,\n        options = ctx.options,\n        resultsList = ctx.resultsList,\n        resultItem = ctx.resultItem;\n    for (var option in options) {\n      if (_typeof(options[option]) === \"object\") {\n        if (!ctx[option]) ctx[option] = {};\n        for (var subOption in options[option]) {\n          ctx[option][subOption] = options[option][subOption];\n        }\n      } else {\n        ctx[option] = options[option];\n      }\n    }\n    ctx.selector = ctx.selector || \"#\" + name;\n    resultsList.destination = resultsList.destination || ctx.selector;\n    resultsList.id = resultsList.id || name + \"_list_\" + ctx.id;\n    resultItem.id = resultItem.id || name + \"_result\";\n    ctx.input = select$1(ctx.selector);\n  });\n\n  var eventEmitter = (function (name, ctx) {\n    ctx.input.dispatchEvent(new CustomEvent(name, {\n      bubbles: true,\n      detail: ctx.feedback,\n      cancelable: true\n    }));\n  });\n\n  var search = (function (query, record, options) {\n    var _ref = options || {},\n        mode = _ref.mode,\n        diacritics = _ref.diacritics,\n        highlight = _ref.highlight;\n    var nRecord = format(record, diacritics);\n    record = String(record);\n    query = format(query, diacritics);\n    if (mode === \"loose\") {\n      query = query.replace(/ /g, \"\");\n      var qLength = query.length;\n      var cursor = 0;\n      var match = Array.from(record).map(function (character, index) {\n        if (cursor < qLength && nRecord[index] === query[cursor]) {\n          character = highlight ? mark(character, highlight) : character;\n          cursor++;\n        }\n        return character;\n      }).join(\"\");\n      if (cursor === qLength) return match;\n    } else {\n      var _match = nRecord.indexOf(query);\n      if (~_match) {\n        query = record.substring(_match, _match + query.length);\n        _match = highlight ? record.replace(query, mark(query, highlight)) : record;\n        return _match;\n      }\n    }\n  });\n\n  var getData = function getData(ctx, query) {\n    return new Promise(function ($return, $error) {\n      var data;\n      data = ctx.data;\n      if (data.cache && data.store) return $return();\n      return new Promise(function ($return, $error) {\n        if (typeof data.src === \"function\") {\n          return data.src(query).then($return, $error);\n        }\n        return $return(data.src);\n      }).then(function ($await_4) {\n        try {\n          ctx.feedback = data.store = $await_4;\n          eventEmitter(\"response\", ctx);\n          return $return();\n        } catch ($boundEx) {\n          return $error($boundEx);\n        }\n      }, $error);\n    });\n  };\n  var findMatches = function findMatches(query, ctx) {\n    var data = ctx.data,\n        searchEngine = ctx.searchEngine;\n    var matches = [];\n    data.store.forEach(function (value, index) {\n      var find = function find(key) {\n        var record = key ? value[key] : value;\n        var match = typeof searchEngine === \"function\" ? searchEngine(query, record) : search(query, record, {\n          mode: searchEngine,\n          diacritics: ctx.diacritics,\n          highlight: ctx.resultItem.highlight\n        });\n        if (!match) return;\n        var result = {\n          match: match,\n          value: value\n        };\n        if (key) result.key = key;\n        matches.push(result);\n      };\n      if (data.keys) {\n        var _iterator = _createForOfIteratorHelper(data.keys),\n            _step;\n        try {\n          for (_iterator.s(); !(_step = _iterator.n()).done;) {\n            var key = _step.value;\n            find(key);\n          }\n        } catch (err) {\n          _iterator.e(err);\n        } finally {\n          _iterator.f();\n        }\n      } else {\n        find();\n      }\n    });\n    if (data.filter) matches = data.filter(matches);\n    var results = matches.slice(0, ctx.resultsList.maxResults);\n    ctx.feedback = {\n      query: query,\n      matches: matches,\n      results: results\n    };\n    eventEmitter(\"results\", ctx);\n  };\n\n  var Expand = \"aria-expanded\";\n  var Active = \"aria-activedescendant\";\n  var Selected = \"aria-selected\";\n  var feedback = function feedback(ctx, index) {\n    ctx.feedback.selection = _objectSpread2({\n      index: index\n    }, ctx.feedback.results[index]);\n  };\n  var render = function render(ctx) {\n    var resultsList = ctx.resultsList,\n        list = ctx.list,\n        resultItem = ctx.resultItem,\n        feedback = ctx.feedback;\n    var matches = feedback.matches,\n        results = feedback.results;\n    ctx.cursor = -1;\n    list.innerHTML = \"\";\n    if (matches.length || resultsList.noResults) {\n      var fragment = new DocumentFragment();\n      results.forEach(function (result, index) {\n        var element = create(resultItem.tag, _objectSpread2({\n          id: \"\".concat(resultItem.id, \"_\").concat(index),\n          role: \"option\",\n          innerHTML: result.match,\n          inside: fragment\n        }, resultItem[\"class\"] && {\n          \"class\": resultItem[\"class\"]\n        }));\n        if (resultItem.element) resultItem.element(element, result);\n      });\n      list.append(fragment);\n      if (resultsList.element) resultsList.element(list, feedback);\n      open(ctx);\n    } else {\n      close(ctx);\n    }\n  };\n  var open = function open(ctx) {\n    if (ctx.isOpen) return;\n    (ctx.wrapper || ctx.input).setAttribute(Expand, true);\n    ctx.list.removeAttribute(\"hidden\");\n    ctx.isOpen = true;\n    eventEmitter(\"open\", ctx);\n  };\n  var close = function close(ctx) {\n    if (!ctx.isOpen) return;\n    (ctx.wrapper || ctx.input).setAttribute(Expand, false);\n    ctx.input.setAttribute(Active, \"\");\n    ctx.list.setAttribute(\"hidden\", \"\");\n    ctx.isOpen = false;\n    eventEmitter(\"close\", ctx);\n  };\n  var goTo = function goTo(index, ctx) {\n    var resultItem = ctx.resultItem;\n    var results = ctx.list.getElementsByTagName(resultItem.tag);\n    var cls = resultItem.selected ? resultItem.selected.split(\" \") : false;\n    if (ctx.isOpen && results.length) {\n      var _results$index$classL;\n      var state = ctx.cursor;\n      if (index >= results.length) index = 0;\n      if (index < 0) index = results.length - 1;\n      ctx.cursor = index;\n      if (state > -1) {\n        var _results$state$classL;\n        results[state].removeAttribute(Selected);\n        if (cls) (_results$state$classL = results[state].classList).remove.apply(_results$state$classL, _toConsumableArray(cls));\n      }\n      results[index].setAttribute(Selected, true);\n      if (cls) (_results$index$classL = results[index].classList).add.apply(_results$index$classL, _toConsumableArray(cls));\n      ctx.input.setAttribute(Active, results[ctx.cursor].id);\n      ctx.list.scrollTop = results[index].offsetTop - ctx.list.clientHeight + results[index].clientHeight + 5;\n      ctx.feedback.cursor = ctx.cursor;\n      feedback(ctx, index);\n      eventEmitter(\"navigate\", ctx);\n    }\n  };\n  var next = function next(ctx) {\n    goTo(ctx.cursor + 1, ctx);\n  };\n  var previous = function previous(ctx) {\n    goTo(ctx.cursor - 1, ctx);\n  };\n  var select = function select(ctx, event, index) {\n    index = index >= 0 ? index : ctx.cursor;\n    if (index < 0) return;\n    ctx.feedback.event = event;\n    feedback(ctx, index);\n    eventEmitter(\"selection\", ctx);\n    close(ctx);\n  };\n  var click = function click(event, ctx) {\n    var itemTag = ctx.resultItem.tag.toUpperCase();\n    var items = Array.from(ctx.list.querySelectorAll(itemTag));\n    var item = event.target.closest(itemTag);\n    if (item && item.nodeName === itemTag) {\n      select(ctx, event, items.indexOf(item));\n    }\n  };\n  var navigate = function navigate(event, ctx) {\n    switch (event.keyCode) {\n      case 40:\n      case 38:\n        event.preventDefault();\n        event.keyCode === 40 ? next(ctx) : previous(ctx);\n        break;\n      case 13:\n        if (!ctx.submit) event.preventDefault();\n        if (ctx.cursor >= 0) select(ctx, event);\n        break;\n      case 9:\n        if (ctx.resultsList.tabSelect && ctx.cursor >= 0) select(ctx, event);\n        break;\n      case 27:\n        ctx.input.value = \"\";\n        close(ctx);\n        break;\n    }\n  };\n\n  function start (ctx, q) {\n    var _this = this;\n    return new Promise(function ($return, $error) {\n      var queryVal, condition;\n      queryVal = q || getQuery(ctx.input);\n      queryVal = ctx.query ? ctx.query(queryVal) : queryVal;\n      condition = checkTrigger(queryVal, ctx.trigger, ctx.threshold);\n      if (condition) {\n        return getData(ctx, queryVal).then(function ($await_2) {\n          try {\n            if (ctx.feedback instanceof Error) return $return();\n            findMatches(queryVal, ctx);\n            if (ctx.resultsList) render(ctx);\n            return $If_1.call(_this);\n          } catch ($boundEx) {\n            return $error($boundEx);\n          }\n        }, $error);\n      } else {\n        close(ctx);\n        return $If_1.call(_this);\n      }\n      function $If_1() {\n        return $return();\n      }\n    });\n  }\n\n  var eventsManager = function eventsManager(events, callback) {\n    for (var element in events) {\n      for (var event in events[element]) {\n        callback(element, event);\n      }\n    }\n  };\n  var addEvents = function addEvents(ctx) {\n    var events = ctx.events;\n    var run = debounce(function () {\n      return start(ctx);\n    }, ctx.debounce);\n    var publicEvents = ctx.events = _objectSpread2({\n      input: _objectSpread2({}, events && events.input)\n    }, ctx.resultsList && {\n      list: events ? _objectSpread2({}, events.list) : {}\n    });\n    var privateEvents = {\n      input: {\n        input: function input() {\n          run();\n        },\n        keydown: function keydown(event) {\n          navigate(event, ctx);\n        },\n        blur: function blur() {\n          close(ctx);\n        }\n      },\n      list: {\n        mousedown: function mousedown(event) {\n          event.preventDefault();\n        },\n        click: function click$1(event) {\n          click(event, ctx);\n        }\n      }\n    };\n    eventsManager(privateEvents, function (element, event) {\n      if (!ctx.resultsList && event !== \"input\") return;\n      if (publicEvents[element][event]) return;\n      publicEvents[element][event] = privateEvents[element][event];\n    });\n    eventsManager(publicEvents, function (element, event) {\n      ctx[element].addEventListener(event, publicEvents[element][event]);\n    });\n  };\n  var removeEvents = function removeEvents(ctx) {\n    eventsManager(ctx.events, function (element, event) {\n      ctx[element].removeEventListener(event, ctx.events[element][event]);\n    });\n  };\n\n  function init (ctx) {\n    var _this = this;\n    return new Promise(function ($return, $error) {\n      var placeHolder, resultsList, parentAttrs;\n      placeHolder = ctx.placeHolder;\n      resultsList = ctx.resultsList;\n      parentAttrs = {\n        role: \"combobox\",\n        \"aria-owns\": resultsList.id,\n        \"aria-haspopup\": true,\n        \"aria-expanded\": false\n      };\n      create(ctx.input, _objectSpread2(_objectSpread2({\n        \"aria-controls\": resultsList.id,\n        \"aria-autocomplete\": \"both\"\n      }, placeHolder && {\n        placeholder: placeHolder\n      }), !ctx.wrapper && _objectSpread2({}, parentAttrs)));\n      if (ctx.wrapper) ctx.wrapper = create(\"div\", _objectSpread2({\n        around: ctx.input,\n        \"class\": ctx.name + \"_wrapper\"\n      }, parentAttrs));\n      if (resultsList) ctx.list = create(resultsList.tag, _objectSpread2({\n        dest: [resultsList.destination, resultsList.position],\n        id: resultsList.id,\n        role: \"listbox\",\n        hidden: \"hidden\"\n      }, resultsList[\"class\"] && {\n        \"class\": resultsList[\"class\"]\n      }));\n      addEvents(ctx);\n      if (ctx.data.cache) {\n        return getData(ctx).then(function ($await_2) {\n          try {\n            return $If_1.call(_this);\n          } catch ($boundEx) {\n            return $error($boundEx);\n          }\n        }, $error);\n      }\n      function $If_1() {\n        eventEmitter(\"init\", ctx);\n        return $return();\n      }\n      return $If_1.call(_this);\n    });\n  }\n\n  function extend (autoComplete) {\n    var prototype = autoComplete.prototype;\n    prototype.init = function () {\n      init(this);\n    };\n    prototype.start = function (query) {\n      start(this, query);\n    };\n    prototype.unInit = function () {\n      if (this.wrapper) {\n        var parentNode = this.wrapper.parentNode;\n        parentNode.insertBefore(this.input, this.wrapper);\n        parentNode.removeChild(this.wrapper);\n      }\n      removeEvents(this);\n    };\n    prototype.open = function () {\n      open(this);\n    };\n    prototype.close = function () {\n      close(this);\n    };\n    prototype.goTo = function (index) {\n      goTo(index, this);\n    };\n    prototype.next = function () {\n      next(this);\n    };\n    prototype.previous = function () {\n      previous(this);\n    };\n    prototype.select = function (index) {\n      select(this, null, index);\n    };\n    prototype.search = function (query, record, options) {\n      return search(query, record, options);\n    };\n  }\n\n  function autoComplete(config) {\n    this.options = config;\n    this.id = autoComplete.instances = (autoComplete.instances || 0) + 1;\n    this.name = \"autoComplete\";\n    this.wrapper = 1;\n    this.threshold = 1;\n    this.debounce = 0;\n    this.resultsList = {\n      position: \"afterend\",\n      tag: \"ul\",\n      maxResults: 5\n    };\n    this.resultItem = {\n      tag: \"li\"\n    };\n    configure(this);\n    extend.call(this, autoComplete);\n    init(this);\n  }\n\n  return autoComplete;\n\n}));\n\n\n//# sourceURL=webpack:///./node_modules/@tarekraafat/autocomplete.js/dist/autoComplete.js?");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./assets/js/fields/city-autocomplete.js");
/******/ 	
/******/ })()
;