<?php
namespace Elementor42\Widgets;

use Elementor42\Utils\BaseWidget;

if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
}

/**
 * Class WooProductMeta
 *
 * @package Elementor42\ElementorWidgets
 */
class WooProductMeta extends BaseWidget {

	use WooProductMetaContentTrait;
	use WooProductMetaStyleTrait;
	use WooProductMetaRenderTrait;

	public function get_name(): string {
		return 'a42-woo-product-meta';
	}

	public function get_title(): ?string {
		return __( 'A42 Woo Product Meta', ELEMENTOR42_SLUG );
	}

	public function get_icon(): string {
		return 'eicon-product-meta';
	}

	public function get_categories(): array {
		return [ 'agency42' ];
	}

	public function get_keywords(): array {
		return [ '42', 'woo', 'product', 'meta' ];
	}

	public function get_style_depends(): array {
		wp_register_style('a42-widget-woo-product-meta', ELEMENTOR42_ASSETS . '/css/components/woo-product-meta.css', [], ELEMENTOR42_VERSION);
		wp_enqueue_style('a42-widget-woo-product-meta');
		return ['anym-utility, a42-widget-woo-product-meta'];
	}

	public function get_script_depends(): array {
		return [];
	}

	public function register_controls(): void {
		$this->register_controls_content();
		$this->register_controls_styles();
	}
}