<?php
namespace Elementor42\Widgets;

use Elementor42\Utils\BaseWidget;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Class Title
 *
 * @package Elementor42\ElementorWidgets
 */
class Title extends BaseWidget {

  use TitleContentTrait;
  use TitleStyleTrait;
  use TitleRenderTrait;

  public function get_name(): string {
    return 'a42-title';
  }

  public function get_title(): ?string {
    return __( 'A42 Title', ELEMENTOR42_SLUG );
  }

  public function get_icon(): string {
    return 'eicon-t-letter';
  }

  public function get_categories(): array {
    return [ 'agency42' ];
  }

  public function get_keywords(): array {
    return [ '42', 'title', 'text', 'heading' ];
  }

  public function get_style_depends(): array {
    wp_register_style('a42-widget-title', ELEMENTOR42_URL . 'assets/css/components/title.css', [], ELEMENTOR42_VERSION);
    wp_enqueue_style('a42-widget-title');
    return ['anym-utility, a42-widget-title'];
  }

  public function get_script_depends(): array {
    return [];
  }

  public function register_controls(): void {
    $this->register_controls_content();
    $this->register_controls_styles();
  }
}