<?php
namespace Elementor42\Widgets;

use Elementor42\Utils\BaseWidget;

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Class ScrollTopBtn
 *
 * @package Elementor42\ElementorWidgets
 */
class ScrollTopBtn extends BaseWidget {
  public function get_name(): string {
    return 'a42-scroll-top-btn';
  }

  public function get_title(): ?string {
    return __('A42 Scroll Top Button', ELEMENTOR42_SLUG);
  }

  public function get_icon(): string {
    return 'eicon-arrow-up';
  }

  public function get_categories(): array {
    return ['agency42'];
  }

  public function get_keywords(): array {
    return ['42', 'scroll', 'top', 'button'];
  }

  public function get_style_depends(): array {
      wp_register_style('a42-widget-scroll-top-btn', ELEMENTOR42_URL . 'assets/css/components/scroll-top-btn.css', [], ELEMENTOR42_VERSION);
    return ['anym-utility', 'a42-widget-scroll-top-btn'];
  }

  public function get_script_depends(): array {
      wp_register_script('a42-widget-scroll-top-btn', ELEMENTOR42_URL . 'assets/js/components/scroll-top-btn.js', [], ELEMENTOR42_VERSION, true);
    return ['a42-widget-scroll-top-btn'];
  }

  public function register_controls(): void {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', ELEMENTOR42_SLUG),
      ]
    );

    $this->add_control(
      'icon',
      [
        'label' => __('Icon', ELEMENTOR42_SLUG),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-arrow-up',
          'library' => 'solid',
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'section_style',
      [
        'label' => __('Style', ELEMENTOR42_SLUG),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control('size', [
      'label' => __('Size', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'size_units' => ['px', 'em', '%'],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} button' => 'font-size: {{SIZE}}{{UNIT}};',
      ],
    ]);

    $this->add_control('width',[
      'label' => __('Width', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'size_units' => ['px', 'em', '%'],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 500,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} button' => 'width: {{SIZE}}{{UNIT}};',
      ],
    ]);

    $this->add_control('height', [
        'label' => __('Height', ELEMENTOR42_SLUG),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', '%'],
        'range' => [
            'px' => [
            'min' => 0,
            'max' => 500,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} button' => 'height: {{SIZE}}{{UNIT}};',
        ],
    ]);

    $this->add_control('padding', [
      'label' => __('Padding', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', 'em', '%'],
      'selectors' => [
        '{{WRAPPER}} button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
    ]);

    $this->start_controls_tabs('tabs_style');
    $this->start_controls_tab(
      'tab_style_normal',
      [
        'label' => __('Normal', ELEMENTOR42_SLUG),
      ]
    );

    $this->add_control('color', [
      'label' => __('Color', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#000000',
      'selectors' => [
        '{{WRAPPER}} button' => 'color: {{VALUE}};',
        '{{WRAPPER}} button svg' => 'fill: {{VALUE}};',
      ],
    ]);

    $this->add_control('background_color', [
      'label' => __('Background Color', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#ffffff',
      'selectors' => [
        '{{WRAPPER}} button' => 'background-color: {{VALUE}};',
      ],
    ]);

    $this->add_control('border_style', [
        'label' => __('Border Style', ELEMENTOR42_SLUG),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'none' => __('None', ELEMENTOR42_SLUG),
            'solid' => __('Solid', ELEMENTOR42_SLUG),
            'dashed' => __('Dashed', ELEMENTOR42_SLUG),
            'dotted' => __('Dotted', ELEMENTOR42_SLUG),
            'double' => __('Double', ELEMENTOR42_SLUG),
            'groove' => __('Groove', ELEMENTOR42_SLUG),
            'inset' => __('Inset', ELEMENTOR42_SLUG),
            'outset' => __('Outset', ELEMENTOR42_SLUG),
            'ridge' => __('Ridge', ELEMENTOR42_SLUG),
        ],
        'selectors' => [
            '{{WRAPPER}} button' => 'border-style: {{VALUE}};',
        ],
    ]);

    $this->add_control('border_color', [
      'label' => __('Border Color', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::COLOR,
      'default' => '#000000',
      'selectors' => [
        '{{WRAPPER}} button' => 'border-color: {{VALUE}};',
      ],
      'condition' => [
        'border_style!' => 'none',
      ],
    ]);

    $this->add_control('border_width', [
      'label' => __('Border Width', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', 'em', '%'],
      'selectors' => [
        '{{WRAPPER}} button' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
      'condition' => [
        'border_style!' => 'none',
      ],
    ]);

    $this->add_control('border_radius', [
      'label' => __('Border Radius', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', 'em', '%'],
      'selectors' => [
        '{{WRAPPER}} button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
    ]);

    $this->end_controls_tab();

    $this->start_controls_tab(
      'tab_style_hover',
      [
        'label' => __('Hover', ELEMENTOR42_SLUG),
      ]
    );

    $this->add_control('color_hover', [
      'label' => __('Color', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} button:hover' => 'color: {{VALUE}};',
        '{{WRAPPER}} button:hover svg' => 'fill: {{VALUE}};',
      ],
    ]);

    $this->add_control('background_color_hover', [
      'label' => __('Background Color', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} button:hover' => 'background-color: {{VALUE}};',
      ],
    ]);

    $this->add_control('border_color_hover', [
      'label' => __('Border Color', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} button:hover' => 'border-color: {{VALUE}};',
      ],
      'condition' => [
        'border_style!' => 'none',
      ],
    ]);

    $this->add_control('border_width_hover', [
      'label' => __('Border Width', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', 'em', '%'],
      'selectors' => [
        '{{WRAPPER}} button:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
      'condition' => [
        'border_style!' => 'none',
      ],
    ]);

    $this->add_control('border_radius_hover', [
      'label' => __('Border Radius', ELEMENTOR42_SLUG),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', 'em', '%'],
      'selectors' => [
        '{{WRAPPER}} button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
    ]);

    $this->end_controls_tab();

    $this->end_controls_tabs();

    $this->end_controls_section();


  }

  public function render():void {
    $settings = $this->get_settings_for_display();
    $this->add_render_attribute('wrapper', [
            'class' => 'a42-scroll-top-btn-wrapper flex-center',
    ]);

    ?>
    <button type="button" <?php echo $this->get_render_attribute_string('wrapper'); ?>>
      <span class="a42-scroll-top-btn-icon flex-center">
        <?php $this->render_icon($settings['icon']); ?>
      </span>
    </button>
    <?php
  }
}