<?php
namespace Elementor42\Widgets;

use Elementor\Controls_Manager;
use Elementor\Core\Base\Document;
use ElementorPro\Modules\LoopBuilder\Documents\Loop as LoopDocument;
use ElementorPro\Modules\QueryControl\Controls\Group_Control_Related;
use ElementorPro\Modules\QueryControl\Controls\Template_Query;
use ElementorPro\Modules\QueryControl\Module as QueryControlModule;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait Loop42ContentTrait {

	private function register_controls_content(): void {
		$this->register_controls_selectTemplate();
		$this->register_controls_query();
		$this->register_controls_pagination();
	}


	private function register_controls_selectTemplate() {
		$this->start_controls_section(
			'section_layout',
			[
				'label' => esc_html__( 'Layout', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'template_id',
			[
				'label' => esc_html__( 'Choose a template', 'elementor-pro' ),
				'type' => Template_Query::CONTROL_ID,
				'label_block' => true,
				'autocomplete' => [
					'object' => QueryControlModule::QUERY_OBJECT_LIBRARY_TEMPLATE,
					'query' => [
						'post_status' => Document::STATUS_PUBLISH,
						'meta_query' => [
							[
								'key' => Document::TYPE_META_KEY,
								'value' => LoopDocument::get_type(),
								'compare' => 'IN',
							],
						],
					],
				],
				'actions' => [
					'new' => [
						'visible' => true,
						'document_config' => [
							'type' => LoopDocument::get_type(),
						],
					],
					'edit' => [
						'visible' => true,
					],
				],
				'frontend_available' => true,
			]
		);

		/**
		 * Add a hidden control to show only the loop items
		 * @note This is used for the ajax request
		 */
		$this->add_control(
			'ajax_render',
			[
				'type' => Controls_Manager::HIDDEN,
				'default' => false,
			]
		);

		$this->end_controls_section();
	}


	private function register_controls_query() {
		$this->start_controls_section(
			'a42-loop42-query',
			[
				'label' => __('Query', ELEMENTOR42_SLUG),
			]
		);

		// Posts per page
		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'Posts per page', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::NUMBER,
				'default' => 12,
				'min' => 1,
				'max' => 100,
				'step' => 1,
			]
		);

		// Include by term
		$this->add_group_control(
			Group_Control_Related::get_type(),
			[
				'name' => 'q',
				'presets' => [ 'full' ],
				'exclude' => [
					'posts_per_page', //use the one from Layout section
				],
			]
		);

		// Use ajax cache
		$this->add_control(
			'use_ajax_cache',
			[
				'label' => __( 'Use ajax cache', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content-wording_loop42',
			[
				'label' => __( 'Wording', ELEMENTOR42_SLUG ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		// No posts found
		$this->add_control(
			'no_posts_found',
			[
				'label' => __( 'No posts found', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::TEXT,
				'default' => 'No posts found',
			]
		);

		$this->end_controls_section();
	}

	private function register_controls_pagination() {
		$this->start_controls_section(
			'section_pagination',
			[
				'label' => __( 'Pagination', ELEMENTOR42_SLUG ),
			]
		);

		// Show pagination
		$this->add_control(
			'show_pagination',
			[
				'label' => __( 'Show pagination', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
			]
		);

		// Previous label
		$this->add_control(
			'pagination_previous_label',
			[
				'label' => __( 'Previous label', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::TEXT,
				'default' => '&laquo; Previous',
				'condition' => [
					'show_pagination' => 'yes',
				],
			]
		);

		// Next label
		$this->add_control(
			'pagination_next_label',
			[
				'label' => __( 'Next label', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::TEXT,
				'default' => 'Next  &raquo;',
				'condition' => [
					'show_pagination' => 'yes',
				],
			]
		);

		// Define the pagination page (hidden)
		$this->add_control(
			'pagination_page',
			[
				'label' => __( 'Pagination page', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 0,
			]
		);

		// Page url (hidden)
		$this->add_control(
			'page_url',
			[
				'label' => __( 'Page url', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::HIDDEN,
				'default' => '',
			]
		);

		// Scroll to top offset (on pagination click)
		$this->add_responsive_control(
			'scroll_to_top_offset',
			[
				'label' => __( 'Scroll to top offset', ELEMENTOR42_SLUG ),
				'description' => __( 'Example: Put the Top Menu height (in px)', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'min' => -500,
				'max' => 1000,
				'step' => 1,
				'condition' => [
					'show_pagination' => 'yes',
				],
			]
		);

		$this->end_controls_section();
	}
}
