<?php
namespace Elementor42\Widgets;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait LoopFilter42StyleTrait {

	private function register_controls_styles():void {
		$this->_itemStyles(0);
		$this->_itemStyles(1);
		$this->_itemStyles(2);
	}

	private function _itemStyles($level): void {
		$this->start_controls_section(
			'section_style_loop-filter42_lvl' . $level,
			[
				'label' => __( 'Items level ' . $level, ELEMENTOR42_SLUG ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		// Gap
		$this->add_responsive_control(
			'item_spacing_lvl' . $level,
			[
				'label' => __( 'Spacing', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .items-wrapper' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// Gap (between parent and children wrapper)
		$this->add_responsive_control(
			'item_spacing_lvl_parents' . $level,
			[
				'label' => __( 'Spacing Parent to childrens', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item-wrapper.active > .items-wrapper' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// Padding
		$this->add_responsive_control(
			'item_padding_lvl'. $level,
			[
				'label' => __( 'Padding', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// Children arrow Icon size
		$this->add_responsive_control(
			'children_arrow_icon_size_lvl' . $level,
			[
				'label' => __( 'Children arrow Icon size', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
					],
					'em' => [
						'min' => 0.1,
						'max' => 10,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .children_arrow_icon svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs('item_style_tabs_lvl' . $level );
		/**
		 * @note  NORMAL TAB
		 */
		$this->start_controls_tab(
			'item_normal_lvl' . $level,
			[
				'label' => __( 'Normal', ELEMENTOR42_SLUG ),
			]
		);
		// Typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'item_typography_lvl' . $level,
				'label' => __( 'Typography', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item',
			]
		);

		// Background
		$this->add_control(
			'item_background_lvl' . $level,
			[
				'label' => __( 'Background', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Color
		$this->add_control(
			'item_color_lvl' . $level,
			[
				'label' => __( 'Color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item' => 'color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'item_border_lvl' . $level,
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item-wrapper',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'item_border_radius_lvl' . $level,
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// Icon color
		$this->add_control(
			'item_icon_color_lvl' . $level,
			[
				'label' => __( 'Icon Arrow color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .children_arrow_icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		/**
		 * @note  HOVER TAB
		 */
		$this->start_controls_tab(
			'item_hover_lvl' . $level,
			[
				'label' => __( 'Hover', ELEMENTOR42_SLUG ),
			]
		);
		// Background
		$this->add_control(
			'item_background_hover_lvl' . $level,
			[
				'label' => __( 'Background', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Color
		$this->add_control(
			'item_color_hover_lvl' . $level,
			[
				'label' => __( 'Color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item:hover' => 'color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'item_border_hover_lvl' . $level,
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item-wrapper:hover',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'item_border_radius_hover_lvl' . $level,
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item-wrapper:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		/**
		 * @note  ACTIVE TAB
		 */
		$this->start_controls_tab(
			'item_active_lvl' . $level,
			[
				'label' => __( 'Active', ELEMENTOR42_SLUG ),
			]
		);

		// Background
		$this->add_control(
			'item_background_active_lvl' . $level,
			[
				'label' => __( 'Background', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item.active' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Color
		$this->add_control(
			'item_color_active_lvl' . $level,
			[
				'label' => __( 'Color', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item.active' => 'color: {{VALUE}};',
				],
			]
		);

		// Border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'item_border_active_lvl' . $level,
				'label' => __( 'Border', ELEMENTOR42_SLUG ),
				'selector' => '{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item-wrapper.active',
			]
		);

		// Border radius
		$this->add_responsive_control(
			'item_border_radius_active_lvl' . $level,
			[
				'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} [data-level="'.$level.'"] .a42-loop-filter42--item-wrapper.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tabs();



		$this->end_controls_section();
	}
}