<?php
/**
 * Utils Functions for Elementor
 *
 * @package Elementor42\Utils
 * @subpackage Elementor42\Utils
 * @since 1.0.0
 * @author Soheil Saheb-Jamii
 */

namespace Elementor42\Utils;

/**
 * Get the color from the Elementor global colors
 * If the color is global, then it will be returned as a CSS variable
 * @param $key array The key of the variable containing the color
 * @param $keyname string The name of the key for the color (default: 'color')
 * @return mixed|string The color
 */
function getCssColor(array $key, string $keyname = 'color'): mixed {
  if (!empty($key) && !empty($key['__globals__']) && !empty($key['__globals__'][$keyname])) {
    $format_color = preg_replace('/globals\/colors\?id=/',
      '',
      $key['__globals__'][$keyname]
    );
    return 'var(--e-global-color-' . $format_color . ')';
  } else if (!empty($key) && !empty($key[$keyname])) {
    return $key[$keyname];
  } else {
    return '';
  }
}