const fs = require('fs');
const url = 'https://geo.api.gouv.fr/communes';

/**
 * This script is used to update the cities in the json file
 */
fetch(url)
    .then(response => response.json())
    .then(data => {
        // City : ['codePostal, nom']
        const cities = [];
        data.forEach(city => {
            city.codesPostaux.forEach(code => {
                cities.push(code + ', ' + city.nom);
            });

            if (city.codesPostaux.length === 0) {
                cities.push(city.code + ', ' + city.nom);
            }
        });

        fs.writeFileSync('../assets/files/cities.json', JSON.stringify(cities));
        console.log('Cities updated');
    });