<?php
namespace Elementor42\Modules\ElementorFormFields;

use Elementor42\CityManager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class FieldDateSelect
 *
 * @package Elementor42\Modules\ElementorFormFields
 */
class FieldCityAutocomplete extends \ElementorPro\Modules\Forms\Fields\Field_Base  {
	/**
	 * @var CityManager
	 */
	private CityManager $cityManager;

	public $depended_scripts = ['a42-field-city-autocomplete-script'];

	public $depended_styles = ['a42-field-city-autocomplete'];

    public function __construct() {
        parent::__construct();
        $this->cityManager = CityManager::getInstance();

    }

	public function get_type(): string {
		return 'a42-city-autocomplete';
	}

	public function get_name(): ?string {
		return __( '[A42] City Autocomplete', 'elementor-pro' );
	}

	public function render( $item, $item_index, $form ): void {
		$form->add_render_attribute( 'input' . $item_index, [
			'placeholder' => $item['custom_placeholder'],
			'class' => 'elementor-field-textual a42CityAutocomplete a42-validation',
			'autocomplete' => 'one-time-code',
		] );

		?>
		<input <?php $form->print_render_attribute_string( 'input' . $item_index ); ?>>
		<?php
	}

	public function validation( $field, $record, $ajax_handler ): void {
        /*if ( preg_match('/^\d{5}, [a-zA-Z ]+$/', $field['value']) !== 1) {
            $ajax_handler->add_error( $field['id'], esc_html__( 'Veuillez entrer un code postal et une ville valides.', ELEMENTOR42_SLUG ) );
        }*/

      // Check if the field is required
        if ( ! empty( $field['required'] ) && empty( $field['value'] ) ) {
            $ajax_handler->add_error( $field['id'], esc_html__( 'Ce champs est requis', ELEMENTOR42_SLUG ) );
        }

        // Check if the field is not empty
      if (!empty($field['value'])) {
        // Check if the field is a valid city and exists in the files/cities.json file
	    $cities = $this->cityManager->getCities();
        if (! $cities) {
          $ajax_handler->add_error( $field['id'], esc_html__( 'Aucune ville trouvée.', ELEMENTOR42_SLUG ) );
        }

        if (!in_array($field['value'], $cities)) {
          $ajax_handler->add_error( $field['id'], esc_html__( 'Veuillez entrer une ville valide.', ELEMENTOR42_SLUG ) );
        }
      }
	}

	public function update_controls( $widget ): void {
		$elementor = \ElementorPro\Plugin::elementor();

		$control_data = $elementor->controls_manager->get_control_from_stack( $widget->get_unique_name(), 'form_fields' );

		if ( is_wp_error( $control_data ) ) {
			return;
		}

		$field_controls = [
			// Custom placeholder control field
			'a42-city-autocomplete-placeholder' => [
				'name'          => 'custom_placeholder',
				'label'         => esc_html__( 'Placeholder', 'textdomain' ),
				'type'          => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'field_type' => $this->get_type(),
				],
				'tab'           => 'content',
				'inner_tab'     => 'form_fields_content_tab',
				'tabs_wrapper'  => 'form_fields_tabs',
			],
		];
		$control_data['fields'] = $this->inject_field_controls( $control_data['fields'], $field_controls );
		$widget->update_control( 'form_fields', $control_data );
	}
}