<?php

/**
 * Add Template conditions for Elementor
 *
 * @package ElementorMenu42\Modules
 * @subpackage ElementorMenu42\Modules\ClassTemplateConditions
 * @author SAHEB-JAMII Soheil <anym@hotmail.fr>
 */

namespace Elementor42\Modules;

class TemplateConditions {
  public function __construct() {

    // Check if Elementor Pro is active
    if ( !class_exists('\ElementorPro\Modules\ThemeBuilder\Conditions\Condition_Base') ) {
      return;
    }
    add_action('elementor/theme/register_conditions', [$this, 'register_conditions']);
  }

  /**
   * Register conditions
   *
   * @param $conditions_manager
   * @return void
   */
  public function register_conditions($conditions_manager): void {
    require_once( __DIR__ . '/conditions/class-condition-nochild.php' );
    $conditions_manager
      ->get_condition( 'singular' )
      ->register_sub_condition( new Conditions\ConditionNoChild() );
  }
}