<?php
namespace Elementor42;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class CityManager
 * @singleton
 *
 * @package Elementor42
 * @since 1.0.0
 */
class CityManager {
	/**
	 * @var CityManager
	 */
	private static CityManager $instance;

	/**
	 * @var array
	 */
	private array $cities = [];

	/**
	 * Get instance
	 *
	 * @return CityManager
	 */
	public static function getInstance(): CityManager {
		if (!isset(self::$instance)) {
			self::$instance = new CityManager();
		}
		return self::$instance;
	}

	/**
	 * Constructor
	 */
	private function __construct() {
		$this->loadCities();
	}

	/**
	 * Load cities
	 */
	private function loadCities(): void {
		$file = ELEMENTOR42_DIR . 'assets/files/cities.json';
		if ( ! file_exists($file) ) {
			return;
		}
		$content_string = file_get_contents($file);
		if ( ! $content_string ) {
			return;
		}
		$cities = json_decode($content_string, true);
		if ( ! $cities ) {
			return;
		}
		$this->cities = $cities;
	}

	/**
	 * Get cities
	 *
	 * @return array
	 */
	public function getCities(): array {
		return $this->cities;
	}


}