<?php
namespace Elementor42\Widgets;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait CtaStyleTrait {

  private function register_controls_styles(): void {
    $this->_add_style_section(
      __( 'Wrapper', ELEMENTOR42_SLUG ),
      'cta-wrapper',
      '{{WRAPPER}} .a42-cta-wrapper',
      '{{WRAPPER}} .a42-cta-wrapper:hover',
      ['background-advanced', 'transform', 'border', 'border-radius', 'box-shadow', 'padding', 'margin']
    );

    $this->_add_style_section(
      __( 'Icône', ELEMENTOR42_SLUG ),
      'icon',
      '{{WRAPPER}} .a42-cta-icon',
      '{{WRAPPER}} .a42-cta-wrapper:hover .a42-cta-icon',
      ['typography', 'transform', 'background', 'background-advanced', 'border', 'border-radius', 'box-shadow', 'opacity', 'padding', 'margin']
    );

    $this->_add_style_section(
      __( 'Titre', ELEMENTOR42_SLUG ),
      'cta-hn-title',
      '{{WRAPPER}} .cta-hn-title',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-hn-title',
      ['typography', 'transform', 'background', 'padding', 'margin']
    );

    $this->_Add_style_section(
      __( 'Pré-titre', ELEMENTOR42_SLUG ),
      'cta-pre_title',
      '{{WRAPPER}} .cta-pre_title',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-pre_title',
      ['typography', 'transform', 'background', 'padding', 'margin']
    );

    $this->_Add_style_section(
      __( 'Sous-titre', ELEMENTOR42_SLUG ),
      'cta-sub_title',
      '{{WRAPPER}} .cta-sub_title',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-sub_title',
      ['typography', 'transform', 'background', 'padding', 'margin']
    );

    $this->_Add_style_section(
      __( 'Titre custom', ELEMENTOR42_SLUG ),
      'cta-custom_title',
      '{{WRAPPER}} .cta-custom_title',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-custom_title',
      ['typography', 'transform', 'background', 'padding', 'margin']
    );

    $this->_add_style_section(
      __( 'Texte', ELEMENTOR42_SLUG ),
      'cta-text',
      '{{WRAPPER}} .cta-text',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-text',
      ['typography', 'transform', 'padding', 'margin']
    );

    $this->_add_style_section(
      __( 'Bouton Primaire', ELEMENTOR42_SLUG ),
      'cta-button-primary',
      '{{WRAPPER}} .cta-button-primary',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-button-primary',
      ['typography', 'transform', 'background-advanced', 'border', 'border-radius', 'box-shadow', 'opacity', 'padding', 'margin']
    );

    $this->_add_style_section(
      __( 'Bouton Secondaire', ELEMENTOR42_SLUG ),
      'cta-button-secondary',
      '{{WRAPPER}} .cta-button-secondary',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-button-secondary',
      ['typography', 'transform', 'background-advanced', 'border', 'border-radius', 'box-shadow', 'opacity', 'padding', 'margin']
    );

    $this->_add_style_section(
      __( 'Bouton Tertiaire', ELEMENTOR42_SLUG ),
      'cta-button-tertiary',
      '{{WRAPPER}} .cta-button-tertiary',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-button-tertiary',
      ['typography', 'transform', 'background-advanced', 'border', 'border-radius', 'box-shadow', 'opacity', 'padding', 'margin']
    );

    $this->_add_style_section(
      __( 'Séparateur', ELEMENTOR42_SLUG ),
      'cta-divider',
      '{{WRAPPER}} .cta-divider',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-divider',
      ['background', 'transform', 'border-radius', 'padding', 'margin', 'width', 'height']
    );

    $this->_add_style_section(
      __( 'HTML', ELEMENTOR42_SLUG ),
      'cta-html-wrapper',
      '{{WRAPPER}} .cta-html-wrapper',
      '{{WRAPPER}} .a42-cta-wrapper:hover .cta-html-wrapper',
      ['typography', 'transform', 'border-radius', 'padding', 'margin', 'width', 'height']
    );

  }

  /**
   * Creates a section with a set of style controls
   * for a given selector
   * @param string $label The label of the section
   * @param string $slug The slug of the section
   * @param string $selector The CSS selector
   * @param array $controls The controls to add
   *    ['typography', 'transform', 'background',
   *    'background-advanced', 'border', 'border-radius',
   * 'box-shadow', 'opacity', 'padding', 'margin', 'width', 'height']
   */
  private function _add_style_section(
    string $label,
    string $slug,
    string $selector = '',
    string $selector_hover = '',
    array $controls = []
  ): void {
    $this->start_controls_section(
      'section_style_title_' . $slug,
      [
        'label' => $label,
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    // Tabs
    $this->start_controls_tabs( 'tabs_title_' . $slug );
    /**
     ***** TAB Normal *****
     */
    $this->start_controls_tab(
      'tab_title_' . $slug . '_normal',
      [
        'label' => __( 'Normal', ELEMENTOR42_SLUG ),
      ]
    );


    // Typography normal
    if (in_array('typography', $controls)) {
      $this->add_control($slug . '_heading-typography_normal', [
        'label' => __( 'Typography', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]);
      $this->add_quick_typography_controls(
        $slug . '_normal',
        $selector,
      );
    }

    // Transform normal
    if (in_array('transform', $controls)) {
      $this->_add_transform_controls(
        $slug . '_normal',
        $selector);
    }

    // Background normal
    if (in_array('background', $controls)) {
      $this->add_control($slug . '_heading-background_normal', [
        'label' => __( 'Background', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]);
      $this->add_control($slug . '_background-color', [
        'label' => __( 'Color', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          $selector => 'background-color: {{VALUE}};',
        ],
      ]);
    }

    // Background advanced normal
    if (in_array('background-advanced', $controls)) {
      $this->add_control($slug . '_background-advanced_heading', [
        'label' => __( 'Background avancé', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]);
      $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
          'name' => $slug . '_background-advanced',
          'label' => __( 'Background avancé', ELEMENTOR42_SLUG ),
          'types' => [ 'classic', 'gradient' ],
          'selector' => $selector,
        ]
      );
    }

    // Border normal
    if (in_array('border', $controls) || in_array('border-radius', $controls)) {
      $this->add_control($slug . '_heading-border_normal', [
        'label' => __( 'Border', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]);
    }
    if (in_array('border', $controls)) {
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => $slug . '_border',
          'label' => __( 'Border', ELEMENTOR42_SLUG ),
          'selector' => '{{WRAPPER}} ' . $selector,
          'default' => '',
          'separator' => 'after',
        ]
      );
    }

    // Border radius normal
    if (in_array('border-radius', $controls)) {
      $this->add_responsive_control($slug . '_border-radius', [
        'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]);
    }

    // Box shadow normal
    if (in_array('box-shadow', $controls)) {
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => $slug . '_box-shadow',
          'label' => __( 'Box shadow', ELEMENTOR42_SLUG ),
          'selector' => $selector,
        ]
      );
    }

    // Opacity normal
    if (in_array('opacity', $controls)) {
      $this->add_control($slug . '_opacity', [
        'label' => __( 'Opacity', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1,
            'step' => 0.01,
          ]
        ],
        'selectors' => [
          $selector => 'opacity: {{SIZE}};',
        ],
      ]);
    }

    // Padding normal
    if (in_array('padding', $controls)) {
      $this->add_responsive_control($slug . '_padding', [
        'label' => __( 'Padding', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]);
    }

    // Margin normal
    if (in_array('margin', $controls)) {
      $this->add_responsive_control($slug . '_margin', [
        'label' => __( 'Margin', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]);
    }

    // Width normal
    if (in_array('width', $controls)) {
      $this->add_responsive_control($slug . '_width', [
        'label' => __( 'Width', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]);
    }

    // Height normal
    if (in_array('height', $controls)) {
      $this->add_responsive_control($slug . '_height', [
        'label' => __( 'Height', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]);
    }


    $this->end_controls_tab();

    /**
     ***** TAB Hover *****
     */
    $this->start_controls_tab(
      'tab_title_' . $slug . '_hover',
      [
        'label' => __( 'Hover', ELEMENTOR42_SLUG ),
      ]
    );

    // Typography hover
    if (in_array('typography', $controls)) {
      $this->add_control($slug . '_heading-typography_hover', [
        'label' => __( 'Typography', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]);
      $this->add_quick_typography_controls(
        $slug . '_hover',
        $selector_hover,
      );
    }

    // Transform hover
    if (in_array('transform', $controls)) {
      $this->_add_transform_controls(
        $slug . '_hover',
        $selector_hover);
    }

    // Background hover
    if (in_array('background', $controls)) {
      $this->add_control($slug . '_heading-background_hover', [
        'label' => __( 'Background', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]);
      $this->add_control($slug . '_background-color_hover', [
        'label' => __( 'Color', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          $selector_hover => 'background-color: {{VALUE}};',
        ],
      ]);
    }

    // Background advanced hover
    if (in_array('background-advanced', $controls)) {
      $this->add_control($slug . '_background-advanced_heading', [
        'label' => __( 'Background avancé', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]);
      $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
          'name' => $slug . '_background-advanced_hover',
          'label' => __( 'Background avancé', ELEMENTOR42_SLUG ),
          'types' => [ 'classic', 'gradient' ],
          'selector' => $selector_hover,
        ]
      );
    }

    // Border hover
    if (in_array('border', $controls) || in_array('border-radius', $controls)) {
      $this->add_control($slug . '_heading-border_hover', [
        'label' => __( 'Border', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]);
    }
    if (in_array('border', $controls)) {
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => $slug . '_border_hover',
          'label' => __( 'Border', ELEMENTOR42_SLUG ),
          'selector' => $selector_hover,
        ]
      );
    }

    // Border radius hover
    if (in_array('border-radius', $controls)) {
      $this->add_responsive_control($slug . '_border-radius_hover', [
        'label' => __( 'Border radius', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector_hover => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]);
    }

    // Box shadow hover
    if (in_array('box-shadow', $controls)) {
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => $slug . '_box-shadow_hover',
          'label' => __( 'Box shadow', ELEMENTOR42_SLUG ),
          'selector' => $selector_hover,
        ]
      );
    }

    // Opacity hover
    if (in_array('opacity', $controls)) {
      $this->add_control($slug . '_opacity_hover', [
        'label' => __( 'Opacity', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 1,
            'step' => 0.01,
          ]
        ],
        'selectors' => [
          $selector_hover => 'opacity: {{SIZE}};',
        ],
      ]);
    }

    // Padding hover
    if (in_array('padding', $controls)) {
      $this->add_responsive_control($slug . '_padding_hover', [
        'label' => __( 'Padding', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector_hover => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]);
    }

    // Margin hover
    if (in_array('margin', $controls)) {
      $this->add_responsive_control($slug . '_margin_hover', [
        'label' => __( 'Margin', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector_hover => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]);
    }

    // Width hover
    if (in_array('width', $controls)) {
      $this->add_responsive_control($slug . '_width_hover', [
        'label' => __( 'Width', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector_hover => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]);
    }

    // Height hover
    if (in_array('height', $controls)) {
      $this->add_responsive_control($slug . '_height_hover', [
        'label' => __( 'Height', ELEMENTOR42_SLUG ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          $selector_hover => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]);
    }




    $this->end_controls_tab();
    $this->end_controls_tabs();


    $this->end_controls_section();
  }

  /**
   * Transformation controls
   */
  private function _add_transform_controls(
    string $slug,
    string $selector,
  ): void {
    /*$this->add_control($slug . '_heading-transform_normal', [
      'label' => __( 'Transformation', ELEMENTOR42_SLUG ),
      'type' => \Elementor\Controls_Manager::HEADING,
      'separator' => 'before',
    ]);*/

    $this->add_control(
      $slug.'_popover-toggle_transform_normal',
      [
        'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
        'label' => __( 'Transformation', ELEMENTOR42_SLUG ),
        'return_value' => 'transform_normal',
      ]
    );

    $this->start_popover();
    $this->add_control($slug . '_transform_scale', [
      'label' => __( 'Scale', ELEMENTOR42_SLUG ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 3,
          'step' => 0.01,
        ]
      ],
      'frontend_available' => true,
      'selectors' => [
         $selector => 'transform: scale({{SIZE}});',
      ],
    ]);

    $this->add_control($slug . '_move_x', [
      'label' => __( 'Move X', ELEMENTOR42_SLUG ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => [
          'min' => -100,
          'max' => 100,
          'step' => 1,
        ]
      ],
      'frontend_available' => true,
      'selectors' => [
        $selector => 'left: {{SIZE}}px;',
      ],
    ]);

    $this->add_control($slug . '_move_y', [
      'label' => __( 'Move Y', ELEMENTOR42_SLUG ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => [
          'min' => -100,
          'max' => 100,
          'step' => 1,
        ]
      ],
      'frontend_available' => true,
      'selectors' => [
        $selector => 'top: {{SIZE}}px;',
      ],
    ]);

    $this->end_popover();
  }
}