

class ScrollTopBtn {
    /**
     * @constructor
     * @param element {HTMLElement} The button element
     */
    constructor(element) {
        this.element = element;
        this.listenEvents();
    }

    listenEvents() {
        window.addEventListener('scroll', () => {
            this.toggleVisibility();
        });

        this.element.addEventListener('click', () => {
            this.scrollToTop();
        });
    }

    scrollToTop() {
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    }

    toggleVisibility() {
        if (window.scrollY > 150) {
            this.element.classList.add('a42-scroll-top-btn-wrapper--visible');
        } else {
            this.element.classList.remove('a42-scroll-top-btn-wrapper--visible');
        }
    }
}

document.querySelectorAll('button.a42-scroll-top-btn-wrapper').forEach(element => {
    new ScrollTopBtn(element);
});