<?php
namespace ElementorMenu42\Includes;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Update Checker
 *
 * @package Brand42\Includes
 * @since 1.0.0
 */
class UpdateChecker {
  public function __construct() {
    add_filter('plugins_api', [$this, 'check_for_update'], 20, 3);
    add_filter('site_transient_update_plugins', [$this, 'push_update'], 10, 1);
  }

  public function push_update($transient) {
    if (empty($transient->checked)) {
      return $transient;
    }

    $remote = $this->get_remote();
    if ($remote === false) {
      return $transient;
    }

    if (version_compare(ELEMENTOR_MENU42_VERSION, $remote->version, '<')) {
      $res = new \stdClass();
      $res->slug = ELEMENTOR_MENU42_SLUG;
      $res->plugin = ELEMENTOR_MENU42_SLUG . '/' . ELEMENTOR_MENU42_SLUG . '.php';
      $res->new_version = $remote->version;
      $res->url = 'https://plugins-updates.agence42.fr/'.ELEMENTOR_MENU42_SLUG.'/infos.json';
      $res->package = $remote->download_url;
      $transient->response[$res->plugin] = $res;
    }

    return $transient;
  }

  private function get_remote() {
    $remote = wp_remote_get('http://plugins-updates.agence42.fr/elementor-menu42/infos.json', [
      'timeout' => 10,
      'headers' => [
        'Accept' => 'application/json',
      ],
    ]);

    if (is_wp_error($remote) || 200 !== wp_remote_retrieve_response_code($remote) || empty(wp_remote_retrieve_body($remote))) {
      return false;
    }

    $remote = json_decode(wp_remote_retrieve_body($remote));

    if (empty($remote) || empty($remote->version) || empty($remote->download_url)) {
      return false;
    }

    return $remote;
  }


  public function check_for_update_test($res, $action, $args) {

    if ('plugin_information' !== $action) {
      return $res;
    }

    if ('brand42' !== $args->slug) {
      return $res;
    }

    $res = new \stdClass();
    $res->name = 'Elementor Menu42';
    $res->slug = ELEMENTOR_MENU42_SLUG;
    $res->version = '1.1.0';
    $res->tested = '5.8';
    $res->requires = '5.0';
    $res->downloaded = 0;
    $res->last_updated = '2025-05-13';
    $res->sections = [
      'description' => 'Elementor Menu42 is a WordPress plugin that adds a customized menu to your website.',
      'installation' => 'This section describes how to install the plugin and get it working.',
      'changelog' => 'This section describes what has changed in each version of the plugin.',
    ];
    $res->download_link = 'https://elementor-menu42.io/elementor-menu42.zip';
    $res->trunk = 'https://elementor-menu42.io/elementor-menu42.zip';
    $res->banners = [
      'low' => 'https://elementor-menu42.io/banner-low.png',
      'high' => 'https://elementor-menu42.io/banner-high.png',
    ];
    $res->author = 'Brand42';

    return $res;
  }

  public function check_for_update($res, $action, $args) {
    if ('plugin_information' !== $action) {
      return $res;
    }

    if (ELEMENTOR_MENU42_SLUG !== $args->slug) {
      return $res;
    }

    $remote = $this->get_remote();
    if ($remote === false) {
      return $res;
    }

    $res = new \stdClass();
    $res->name = $remote->name;
    $res->slug = ELEMENTOR_MENU42_SLUG;
    $res->version = $remote->version;
    $res->tested = $remote->tested;
    $res->requires = $remote->requires;
    $res->last_updated = $remote->last_updated;
    $res->sections = [
      'description' => $remote->sections->description,
      'installation' => $remote->sections->installation,
      'changelog' => $remote->sections->changelog,
    ];
    $res->download_link = $remote->download_url;
    $res->trunk = $remote->download_url;
    $res->banners = [
      'low' => $remote->banners->low,
      'high' => $remote->banners->high,
    ];
    $res->author = $remote->author;
    if( ! empty( $remote->sections->screenshots ) ) {
      $res->sections[ 'screenshots' ] = $remote->sections->screenshots;
    }

    return $res;
  }
}