<?php
namespace ElementorMenu42\Widgets;

// use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
// use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait MenuStyleTrait {

  private function register_controls_styles(): void {
    /**
     * Main menu style
     */
    $this->start_controls_section(
      'section_main-style_menu',
      [
        'label' => __( 'Menu', ELEMENTOR_MENU42_SLUG ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    // Main menu Left / center / right
    $this->add_control(
      'menu__align',
      [
        'label' => __( 'Menu align', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'options' => [
          'flex-start' => [
            'title' => __( 'Left', ELEMENTOR_MENU42_SLUG ),
            'icon' => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => __( 'Center', ELEMENTOR_MENU42_SLUG ),
            'icon' => 'eicon-text-align-center',
          ],
          'flex-end' => [
            'title' => __( 'Right', ELEMENTOR_MENU42_SLUG ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'default' => 'left',
        'toggle' => true,
        'selectors' => [
          '{{WRAPPER}} .elementor-widget-container, {{WRAPPER}} .elementor-widget-container > .main-menu' => 'justify-content: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_section();

    /**
     * Main menu items
     */
    $this->start_controls_section(
      'section_style_menu',
      [
        'label' => __( 'Menu items', ELEMENTOR_MENU42_SLUG ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->start_controls_tabs( 'tabs_main_menu_desktop' );

    // Desktop normal
    $this->start_controls_tab('tab_main_menu_desktop_normal',['label' => __( 'Normal', ELEMENTOR_MENU42_SLUG )]);

    /** @note Main menu item font style */
    $this->add_quick_typography_controls_responsive(
      'menu-item_desktop_normal',
      ['.menu-item.depth-0 > .item-title'], Global_Colors::COLOR_TEXT, '',
      __( 'Main menu item', ELEMENTOR_MENU42_SLUG )
    );

    // Main menu item
    $this->add_responsive_control(
      'menu-item__desktop__bg-color',
      [
        'label' => __( 'Background color', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menu-item.depth-0 > .item-title' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    /** @note Submenu item font style */
    $this->add_quick_typography_controls_responsive(
      'submenu-item_desktop_normal',
      ['.submenu-item > .item-title'], '', '',
      __( 'Submenu item', ELEMENTOR_MENU42_SLUG )
    );

    // Submenu item Background
    $this->add_responsive_control(
      'submenu-item__desktop__bg-color',
      [
        'label' => __( 'Background color', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .submenu-item' => 'background-color: {{VALUE}}',
        ],
      ]
    );



    $this->end_controls_tab();

    // Desktop hover
    $this->start_controls_tab('tab_main_menu_desktop_hover', ['label' => __( 'Hover', ELEMENTOR_MENU42_SLUG )]);

    /** @note Main menu item font style */
    $this->add_quick_typography_controls_responsive(
      'menu-item_desktop_hover',
      ['.menu-item.depth-0 > .item-title:hover'], '', '',
      __( 'Main menu item', ELEMENTOR_MENU42_SLUG )
    );

    // Main menu item Background
    $this->add_responsive_control(
      'menu-item__desktop__bg-color__hover',
      [
        'label' => __( 'Background color', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menu-item.depth-0 > .item-title:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    /** @note Submenu item font style */
    $this->add_quick_typography_controls_responsive(
      'submenu-item_desktop_hover',
      ['.submenu-item > .submenu-item-title:hover'], '', '',
      __( 'Submenu item', ELEMENTOR_MENU42_SLUG )
    );

    // Submenu item Background
    $this->add_responsive_control(
      'submenu-item__desktop__bg-color__hover',
      [
        'label' => __( 'Background color', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .submenu-item > .submenu-item-title:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_tab();

    $this->end_controls_tabs();
    $this->end_controls_section();


    /** Button primary style */
    $this->add_button_styles('primary');

    /** Button secondary style */
    $this->add_button_styles('secondary');

    /** Button tertiary style */
    $this->add_button_styles('tertiary');

  }

  /**
   * @param $name string Button type name
   * @return void Add button style controls
   */
  private function add_button_styles(string $name): void {
    $this->start_controls_section(
      'section_style_menu_' . $name,
      [
        'label' => __( 'Boutons ' . $name, ELEMENTOR_MENU42_SLUG ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    // Tabs
    $this->start_controls_tabs( 'tabs_buttons_' . $name );
    //normal
    $this->start_controls_tab(
      'tab_buttons_' . $name . '_normal',
      [
        'label' => __( 'Normal', ELEMENTOR_MENU42_SLUG ),
      ]
    );

    /** @note Button font style */
    $this->add_quick_typography_controls(
      'button-label_' . $name,
      '.tool.' . $name . ' .tool-text',
      Global_Colors::COLOR_TEXT,
      Global_Typography::TYPOGRAPHY_PRIMARY,
      __( 'Label', ELEMENTOR_MENU42_SLUG )
    );

    /** @note Button icon style */
    $this->add_quick_typography_controls(
      'button-icon_' . $name,
      '.tool.' . $name . ' .a42-tool-icon',
      Global_Colors::COLOR_TEXT,
      Global_Typography::TYPOGRAPHY_PRIMARY,
      __( 'Icon', ELEMENTOR_MENU42_SLUG )
    );

    $this->add_control(
      'button-bg-color_'. $name .'__normal',
      [
        'label' => __( 'Background color', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tool.' . $name => 'background-color: {{VALUE}}',
        ],
      ]
    );

    // Border
    $this->add_control(
      'button-border-style_' . $name . '__normal',
      [
        'label' => __( 'Border style', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => __( 'Default', ELEMENTOR_MENU42_SLUG ),
          'none' => __( 'None', ELEMENTOR_MENU42_SLUG ),
          'solid' => __( 'Solid', ELEMENTOR_MENU42_SLUG ),
          'dashed' => __( 'Dashed', ELEMENTOR_MENU42_SLUG ),
          'dotted' => __( 'Dotted', ELEMENTOR_MENU42_SLUG ),
          'double' => __( 'Double', ELEMENTOR_MENU42_SLUG ),
          'groove' => __( 'Groove', ELEMENTOR_MENU42_SLUG ),
          'ridge' => __( 'Ridge', ELEMENTOR_MENU42_SLUG ),
          'inset' => __( 'Inset', ELEMENTOR_MENU42_SLUG ),
          'outset' => __( 'Outset', ELEMENTOR_MENU42_SLUG ),
        ],
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tool.' . $name => 'border-style: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'button-border-width_' . $name . '__normal',
      [
        'label' => __( 'Border width', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', 'em', 'rem' ],
        'condition' => [
          'button-border-style_' . $name . '__normal!' => ['none', ''],
        ],
        'selectors' => [
          '{{WRAPPER}} .tool.' . $name => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'button-border-radius_' . $name . '__normal',
      [
        'label' => __( 'Border radius', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', 'em', 'rem' ],
        'condition' => [
          'button-border-style_' . $name . '__normal!' => ['none', ''],
        ],
        'selectors' => [
          '{{WRAPPER}} .tool.' . $name => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'button-border-color_' . $name . '__normal',
      [
        'label' => __( 'Border color', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'button-border-style_' . $name . '__normal!' => ['none', ''],
        ],
        'selectors' => [
          '{{WRAPPER}} .tool.' . $name => 'border-color: {{VALUE}}',
        ],
      ]
    );

    // Padding
    $this->add_control('button-padding_' . $name . '__normal',
      [
        'label' => __( 'Padding', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', 'em', 'rem' ],
        'default' => [
          'top' => '10',
          'right' => '20',
          'bottom' => '10',
          'left' => '20',
          'unit' => 'px',
          'isLinked' => false,
        ],
        'selectors' => [
          '{{WRAPPER}} .tool.' . $name => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_tab();

    //hover
    $this->start_controls_tab(
      'tab_buttons_' . $name . '_hover',
      [
        'label' => __( 'Hover', ELEMENTOR_MENU42_SLUG ),
      ]
    );

    /** @note Button font style */
    $this->add_quick_typography_controls(
      'button-label_'.$name.'__hover',
      '.tool.'.$name.':hover .tool-text',
      Global_Colors::COLOR_TEXT,
      Global_Typography::TYPOGRAPHY_PRIMARY,
      __( 'Label', ELEMENTOR_MENU42_SLUG )
    );

    /** @note Button icon style */
    $this->add_quick_typography_controls(
      'button-icon_'.$name.'__hover',
      '.tool.'.$name.':hover .a42-tool-icon',
      Global_Colors::COLOR_TEXT,
      Global_Typography::TYPOGRAPHY_PRIMARY,
      __( 'Icon', ELEMENTOR_MENU42_SLUG )
    );

    $this->add_control(
      'button-bg-color_'.$name.'__hover',
      [
        'label' => __( 'Background color', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tool.'.$name.':hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    // Border
    $this->add_control(
      'button-border-style_'.$name.'__hover',
      [
        'label' => __( 'Border style', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => __( 'Default', ELEMENTOR_MENU42_SLUG ),
          'none' => __( 'None', ELEMENTOR_MENU42_SLUG ),
          'solid' => __( 'Solid', ELEMENTOR_MENU42_SLUG ),
          'dashed' => __( 'Dashed', ELEMENTOR_MENU42_SLUG ),
          'dotted' => __( 'Dotted', ELEMENTOR_MENU42_SLUG ),
          'double' => __( 'Double', ELEMENTOR_MENU42_SLUG ),
          'groove' => __( 'Groove', ELEMENTOR_MENU42_SLUG ),
          'ridge' => __( 'Ridge', ELEMENTOR_MENU42_SLUG ),
          'inset' => __( 'Inset', ELEMENTOR_MENU42_SLUG ),
          'outset' => __( 'Outset', ELEMENTOR_MENU42_SLUG ),
        ],
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tool.'.$name.':hover' => 'border-style: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'button-border-width_'.$name.'__hover',
      [
        'label' => __( 'Border width', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', 'em', 'rem' ],
        'condition' => [
          'button-border-style_'.$name.'__hover!' => ['none', ''],
        ],
        'selectors' => [
          '{{WRAPPER}} .tool.'.$name.':hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'button-border-radius_'.$name.'__hover',
      [
        'label' => __( 'Border radius', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', 'em', 'rem' ],
        'condition' => [
          'button-border-style_'.$name.'__hover!' => ['none', ''],
        ],
        'selectors' => [
          '{{WRAPPER}} .tool.'.$name.':hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'button-border-color_'.$name.'__hover',
      [
        'label' => __( 'Border color', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'button-border-style_'.$name.'__hover!' => ['none', ''],
        ],
        'selectors' => [
          '{{WRAPPER}} .tool.'.$name.':hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );

    // Padding
    $this->add_control('button-padding_'.$name.'__hover',
      [
        'label' => __( 'Padding', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', 'em', 'rem' ],
        'selectors' => [
          '{{WRAPPER}} .tool.'.$name.':hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();

    /**
     * Show icon at left or right
     */
    $this->add_control(
      'button-icon-position_' . $name,
      [
        'label' => __( 'Icon position', ELEMENTOR_MENU42_SLUG ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => __( 'Left', ELEMENTOR_MENU42_SLUG ),
          'row-reverse' => __( 'Right', ELEMENTOR_MENU42_SLUG ),
        ],
        'default' => 'left',
        'selectors' => [
          '{{WRAPPER}} .tool.' . $name => 'flex-direction: {{VALUE}}',
        ],
      ]
    );



    $this->end_controls_section();
  }
}