<?php
namespace ElementorMenu42\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait MenuRenderTrait {

  private array $levels = [
    0 => "menu-item",
    1 => "submenu-item"
  ];

  /**
   * @inheritdoc \Elementor\Widget_Base::render()
   */
  protected function render(): void {
    $settings = $this->get_settings_for_display();
    $source_menu = wp_get_nav_menu_object($settings['menu_source']);
	$current_page = get_queried_object_id();

	// Add style to main div container
	$this->add_render_attribute('_wrapper', 'style', 'display:none;');

    $loopThroughItems = function($items, $parent = 0) use (&$current_page, &$loopThroughItems) {
      $menu = [];
      foreach ($items as $item) {
        if ($item->menu_item_parent == $parent) {
          $menu[$item->ID] = [
            'title' => $item->title,
            'url' => $item->url,
            'target' => $item->target,
            'classes' => $item->classes,
            'custom_classes' => get_post_meta($item->ID, '_menu_item_custom_class', true),
            'children' => $loopThroughItems($items, $item->ID),
            'current' => $item->object_id == $current_page
          ];
        }
      }
      return $menu;
    };

    $menu = $loopThroughItems(wp_get_nav_menu_items($source_menu->term_id));

    $this->render_output($settings, $menu);
  }

  /**
   * Render content
   */
  protected function render_output(array $settings, $menu): void {
    // Menu
    do_action('a42__main-menu__render:before:inside_panel', $settings, $menu);
    echo "<div class='a42__main-menu main-menu flex flex-wrap'>";
    foreach ($menu as $item) {
      $this->render_menu_item($item, $settings);
    }
      // Tools
      echo "<div class='tools-wrapper flex'>";
        echo "<div class='tools flex gap-20 flex-wrap'>";
        foreach ($settings['tools'] as $tool) {
          $this->render_tool($tool);
        }
        echo "</div>";
      echo "</div>";
    echo "</div>";
  }

  /**
   * @param $item
   * @param $settings
   * @param int $level
   * @return void
   */
  private function render_menu_item($item, $settings, int $level = 0): void {
    $has_children = count($item['children']) > 0;
    $has_children_class = $has_children ? ' has-children' : '';
    $level_str = $level > 1 ? $this->levels[1] . '-' . $level : $this->levels[$level];
    $menu_str = $level > 0 ? 'submenu-item' : 'menu-item';
	$current = $item['current'] ? ' current' : '';
	$wp_classes = !empty($item['classes']) ? ' ' . implode(' ', $item['classes']) : '';

    // Menu item
    echo "<div class='{$level_str} item flex depth-{$level}{$has_children_class}{$current}{$wp_classes}'>";

    $tag = !empty($item['url']) ? 'a' : 'div';
    echo sprintf("<%s %s %s class='%s%s-title item-title flex align-center'>",
      $tag,
      $tag === 'a' ? 'href="' . $item['url'] . '"' : '',
      $tag === 'a' && !empty($item['target']) ? 'target="' . $item['target'] . '"' : '',
      $tag === 'a' ? 'link ' : '',
      $menu_str);
    echo "<span class='item-title-label'>{$item['title']}</span>";
    if ($has_children) {
      $icon = $level === 0 ? 'submenu-arrow-down' : 'submenu-arrow-right';
      $this->render_icon($settings[$icon], $icon);
    }
    echo sprintf("</%s>", $tag);

    // Submenu
    if ($has_children) {
      $level++;
      echo "<div class='a42__main-menu__submenu expand-mobile loading submenu depth-{$level}' data-depth='{$level}'>";
        foreach ($item['children'] as $child) {
          $this->render_menu_item($child, $settings, $level);
        }
      echo "</div>";
    }
    echo "</div>";
  }

  /**
   * Render tool
   */
  private function render_tool($tool): void {
    $link = $tool['link']['url'] ?? '';
    $target = $tool['link']['is_external'] ? ' target="_blank"' : '';
    $link_str = !empty($link) ? "href='{$link}'{$target}" : '';

    echo sprintf("<%s %s class='%s tool flex align-center gap-20'>",
      !empty($link) ? 'a' : 'div',
      $link_str,
      $tool['button_type'],
      );

    $this->render_icon($tool['icon'], 'tool-icon');
    if (!empty($tool['text_field'])) {
      echo '<span class="tool-text">' . $tool['text_field'] . '</span>';
    }
    echo sprintf("</%s>", !empty($link) ? 'a' : 'div');
  }
}