<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.agence42.fr
 * @since             1.0.1
 * @package           Elementor_Menu42
 *
 * @wordpress-plugin
 * Plugin Name:       Elementor Menu42
 * Plugin URI:        https://www.agence42.fr
 * Description:       Overloads the Elementor plugin for simpler use
 * Version:           1.0.0
 * Author:            SAHEB-JAMII Soheil
 * Author URI:        https://anym.fr
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       elementor-menu42
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
  die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
const ELEMENTOR_MENU42_VERSION = '1.1.0';
const ELEMENTOR_MENU42_SLUG = 'elementor-menu42';
define('ELEMENTOR_MENU42_URL', plugin_dir_url(__FILE__));
define('ELEMENTOR_MENU42_DIR', plugin_dir_path(__FILE__));

/**
 * Load the plugin
 */
function run_elementor_menu42(): void {
	
	require_once "includes/class-update-checker.php";
	new ElementorMenu42\Includes\UpdateChecker();

  // Register css
  add_action('wp_enqueue_scripts', function() {
    wp_register_style('elementor-menu42', ELEMENTOR_MENU42_URL . 'assets/css/vendors/anym-utility.css', [], ELEMENTOR_MENU42_VERSION);
  });

  // Run the widgets
  add_action('elementor/widgets/register', function($widgets_manager) {
    require_once ELEMENTOR_MENU42_DIR . '/utils/class-base-widget.php';
    a42_load_directory(ELEMENTOR_MENU42_DIR . '/widgets');
    $widgets_manager->register(new \ElementorMenu42\Widgets\Menu());
    $widgets_manager->register(new \ElementorMenu42\Widgets\MenuButton());
  });

  // Add Elementor category
  add_action('elementor/elements/categories_registered', function($elements_manager) {
    $elements_manager->add_category(
      'agency42',
      [
        'title' => __('Agence42', 'agency42'),
        'icon' => 'fa fa-plug',
      ]
    );
  });
}

/**
 * Load all files in a directory via pattern
 * @param string $directory - The directory to load
 * @param array $pattern - The pattern to load
 * @return void
 */
if (!function_exists('a42_load_directory')) {
  function a42_load_directory(string $directory, array $pattern = ['/*/trait-*.php', '/*/interface-*.php', '/*/class-*.php']): void {
    // For each pattern
    foreach ($pattern as $p) {
      $files = glob($directory . $p);
      foreach ($files as $file) {
        require_once $file;
      }
    }
  }
}
run_elementor_menu42();