

class MenuButton {

    /**
     * True: Menu is open
     * False: Menu is closed
     * @type {boolean}
     */
    openState= false;

    /**
     * Button element
     * @type {Element}
     */
    element;

    /**
     * Menu element
     * @type {Element | null}
     */
    menu = document.querySelector('.elementor-widget-elementor-menu42-menu');

    /**
     * Main header element
     * @type {Element | null}
     */
    header = document.querySelector('#main-header');

    /**
     * Body element
     * @type {Element}
     */
    body;

    /**
     * Breakpoint for mobile menu
     * @type {number}
     */
    breakpoint = 1500;

    /**
     * @constructor
     * @param element {HTMLElement} Container element.
     */
    constructor(element) {
        this.body = document.querySelector('body');
        this.element = element;
        this.element.MenuButton = this;
        this.breakpoint = parseInt(this.element.dataset.breakpoint);
        this.setScreenSize();
        if (!!this.menu) {
            this.menu.MenuButton = this;
            this.listenEvents();
        }
    }

    listenEvents() {
        this.element.addEventListener('click', () => {
            this.toggleMenu();
        });

        window.addEventListener('resize', this.setScreenSize.bind(this));
    }

    setScreenSize() {
        if (window.innerWidth < this.breakpoint) {
            this.body.classList.add('is-mobile');
            this.body.classList.remove('is-desktop');
        } else {
            this.body.classList.remove('is-mobile');
            this.body.classList.add('is-desktop');
        }
    }

    toggleMenu() {
        if(this.openState) {
            this.closeMenu();
        } else {
            this.openMenu();
        }
    }

    openMenu() {
        this.openState = true;
        this.element.classList.add('opened');
        this.menu.classList.add('opened');
        this.body.classList.add('menu-opened');
        if (!!this.header) {
            this.header.classList.add('menu-opened');
        }
    }

    closeMenu() {
        this.openState = false;
        this.element.classList.remove('opened');
        this.menu.classList.remove('opened');
        this.body.classList.remove('menu-opened');
        if (!!this.header) {
            this.header.classList.remove('menu-opened');
        }
    }


}

document.querySelectorAll('.a42-menu-button').forEach(button => {
    new MenuButton(button);
});