<?php
namespace Brand42\Includes;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Update Checker
 *
 * @package Brand42\Includes
 * @since 1.0.0
 */
class UpdateChecker {
  public function __construct() {
    add_filter('plugins_api', [$this, 'check_for_update'], 20, 3);
    add_filter('site_transient_update_plugins', [$this, 'push_update'], 10, 1);
  }

  public function push_update($transient) {
    if (empty($transient->checked)) {
      return $transient;
    }

    $remote = $this->get_remote();
    if ($remote === false) {
      return $transient;
    }

    if (version_compare(BRAND42_VERSION, $remote->version, '<')) {
      $res = new \stdClass();
      $res->slug = 'brand42';
      $res->plugin = 'brand42/brand42.php';
      $res->new_version = $remote->version;
      $res->url = 'https://plugins-updates.agence42.fr/brand42/infos.json';
      $res->package = $remote->download_url;
      $transient->response[$res->plugin] = $res;
    }

    return $transient;
  }

  private function get_remote() {
    $remote = wp_remote_get('http://plugins-updates.agence42.fr/brand42/infos.json', [
      'timeout' => 10,
      'headers' => [
        'Accept' => 'application/json',
      ],
    ]);

    if (is_wp_error($remote) || 200 !== wp_remote_retrieve_response_code($remote) || empty(wp_remote_retrieve_body($remote))) {
      return false;
    }

    $remote = json_decode(wp_remote_retrieve_body($remote));

    if (empty($remote) || empty($remote->version) || empty($remote->download_url)) {
      return false;
    }

    return $remote;
  }


  public function check_for_update_test($res, $action, $args) {

    if ('plugin_information' !== $action) {
      return $res;
    }

    if ('brand42' !== $args->slug) {
      return $res;
    }

    $res = new \stdClass();
    $res->name = 'Brand42';
    $res->slug = 'brand42';
    $res->version = '1.0.4';
    $res->tested = '5.8';
    $res->requires = '5.0';
    $res->downloaded = 0;
    $res->last_updated = '2021-08-25';
    $res->sections = [
      'description' => 'Brand42 is a WordPress plugin that helps you to manage your website.',
      'installation' => 'This section describes how to install the plugin and get it working.',
      'changelog' => 'This section describes what has changed in each version of the plugin.',
    ];
    $res->download_link = 'https://brand42.io/brand42.zip';
    $res->trunk = 'https://brand42.io/brand42.zip';
    $res->banners = [
      'low' => 'https://brand42.io/banner-low.png',
      'high' => 'https://brand42.io/banner-high.png',
    ];
    $res->author = 'Brand42';

    return $res;
  }

  public function check_for_update($res, $action, $args) {
    if ('plugin_information' !== $action) {
      return $res;
    }

    if ('brand42' !== $args->slug) {
      return $res;
    }

    $remote = $this->get_remote();
    if ($remote === false) {
      return $res;
    }

    $res = new \stdClass();
    $res->name = $remote->name;
    $res->slug = 'brand42';
    $res->version = $remote->version;
    $res->tested = $remote->tested;
    $res->requires = $remote->requires;
    $res->last_updated = $remote->last_updated;
    $res->sections = [
      'description' => $remote->sections->description,
      'installation' => $remote->sections->installation,
      'changelog' => $remote->sections->changelog,
    ];
    $res->download_link = $remote->download_url;
    $res->trunk = $remote->download_url;
    $res->banners = [
      'low' => $remote->banners->low,
      'high' => $remote->banners->high,
    ];
    $res->author = $remote->author;
    if( ! empty( $remote->sections->screenshots ) ) {
      $res->sections[ 'screenshots' ] = $remote->sections->screenshots;
    }

    return $res;
  }
}