<?php
namespace Brand42\Modules;

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class AdminUrl {
  private string $admin_url = 'admin42';

  public function __construct() {
    add_action('init', [$this, 'custom_admin_url_rewrite']);
    add_action('template_redirect', [$this, 'block_wp_admin_access']);
    add_action('login_enqueue_scripts', [$this, 'block_wp_login_access']);
    add_filter('login_redirect', [$this, 'redirect_after_login'], 10, 3);
    register_activation_hook(BRAND42_DIR . 'brand42.php', [$this, 'activate']);
    register_deactivation_hook(BRAND42_DIR . 'brand42.php', [$this, 'deactivate']);
  }

  public function activate(): void {
    $this->custom_admin_url_rewrite();
    flush_rewrite_rules();
  }

  public function deactivate(): void {
    flush_rewrite_rules();
  }

  public function custom_admin_url_rewrite(): void {
    add_rewrite_rule('^admin42/?$', 'wp-admin/index.php', 'top');
    add_rewrite_rule('^admin42/(.*)', 'wp-admin/$1', 'top');
  }

  public function block_wp_login_access(): void {
    if (strpos($_SERVER['REQUEST_URI'], 'wp-login.php') !== false) {
      wp_redirect(home_url('/404'));
      exit;
    }
  }

  public function block_wp_admin_access(): void {
    if (is_admin() && !current_user_can('administrator') && !wp_doing_ajax()) {
      wp_redirect(home_url('/404'));
      exit;
    }

    if (strpos($_SERVER['REQUEST_URI'], '/wp-login.php') !== false && !is_user_logged_in()) {
      wp_redirect(home_url('/404'));
      exit;
    }

    if (strpos($_SERVER['REQUEST_URI'], '/wp-admin') !== false && !is_user_logged_in()) {
      wp_redirect(home_url('/404'));
      exit;
    }
  }

  /**
   * Redirect to 404 page
   * @return void
   */
  private function redirect_404(): void {
    wp_redirect(home_url('/404'));
    exit;
  }

  public function redirect_after_login($redirect_to, $request, $user): string {
    if (isset($user->roles) && is_array($user->roles)) {
      if (in_array('administrator', $user->roles)) {
        return admin_url();
      } else {
        return home_url();
      }
    }
    return $redirect_to;
  }
}