<?php
namespace Brand42\Modules\Crons;


if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Get Stats Cron
 *
 * @package Brand42\Modules\Crons
 */
class GetStats extends BaseCron {

  public function get_name(): string{
    return 'brand42_get_stat';
  }

  public function get_schedule(): string {
    return 'six_hours';
  }

  protected function job(): void {
    $home_url = get_home_url();

    // Get option from database
    $options = get_option('brand42_pings');

    if ( ! $options ) {
      $options = [];
    }

    // Limit to 30
    if ( count($options) > 30 ) {
      array_shift($options);
    }

    // Ping ms
    $time_start = microtime(true);
    $ping = file_get_contents($home_url);
    $time_end = microtime(true);

    $ping_ms = round(($time_end - $time_start) * 1000, 2);

    // Save to database
    $new_options = [
      'ping' => $ping_ms,
      'date' => date('Y-m-d H:i:s')
    ];

    $options[] = $new_options;

    update_option('brand42_pings', $options);

  }
}