<?php
namespace Brand42\Modules;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Color Scheme Module
 *
 * @package Brand42\Modules\ColorScheme
 */
class ColorScheme {
  public function __construct() {
    add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_assets']);
    add_action('admin_init', [$this, 'register_color_scheme']);

    // Make color scheme by default
    add_filter('get_user_option_admin_color', [$this, 'set_default_color_scheme']);

    // Enqueue admin style for admin bar
    add_action('wp_before_admin_bar_render', [$this, 'enqueue_admin_bar_style']);
  }

  public function enqueue_admin_assets(): void {
    //wp_enqueue_style('brand42-color-scheme', BRAND42_URL . 'assets/css/color-scheme.css');
  }

  public function enqueue_admin_bar_style(): void {
    // Enqueue admin bar style
    if ( ! is_admin_bar_showing() ) {
      return;
    }

    // If the scheme is brand42-color-scheme
    if ( get_user_option('admin_color') !== 'brand42-color-scheme' ) {
      return;
    }
    wp_register_style('brand42-admin-bar-scheme-style', BRAND42_ASSETS . '/css/admin-bar-scheme.css', [], BRAND42_VERSION);
    wp_enqueue_style('brand42-admin-bar-scheme-style');
  }

  public function register_color_scheme(): void {
    //add_theme_support('editor-color-palette', $this->get_color_palette());

    wp_admin_css_color(
      'brand42-color-scheme',
      'Agence42',
      BRAND42_ASSETS . '/css/color-scheme.css',
      $this->get_color_palette(),
      $this->get_icon_color_palette()
    );
  }

  private function get_color_palette(): array {
    return [
      'base'         => '#05081c',
      'icon'         => '#17abc1',
      'highlight'    => '#4ed3a4',
    ];
  }

  private function get_icon_color_palette(): array {
    return [
      'base'    => '#23282d',
      'focus'   => '#fff',
      'current' => '#fff',
    ];
  }

  public function set_default_color_scheme(): string {
    return 'brand42-color-scheme';
  }
}