<?php
namespace Brand42\Modules;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * AdminUrl Module
 *
 * @package AdminUrl\Modules
 */
class AdminUrl {
  public function __construct() {
    // Create new login page
    add_action('init', [$this, 'create_new_login_page']);

    // Block access to the default login page
    add_action('init', [$this, 'block_default_login_page']);

    // Redirect after login
    add_action('wp_login', [$this, 'redirect_after_login'], 10, 2);
  }

  public function block_default_login_page() {
    // Get the option
    $change_admin_url = get_option('brand42_change_admin_url');

    // If the option is set to true
    if ($change_admin_url === 'on') {
      // If the current request URI is the default login page
      $conditions = [
        strpos($_SERVER['REQUEST_URI'], '/wp-login.php') !== false,
        strpos($_SERVER['REQUEST_URI'], '/wp-admin') !== false,
      ];

      if (in_array(true, $conditions) && !is_user_logged_in()) {
        // Show a 404 error
        //header('HTTP/1.0 404 Not Found');
        //exit;
      }
    }
  }

  public function create_new_login_page() {
    // Get the option
    $change_admin_url = get_option('brand42_change_admin_url');

    // If the option is set to true
    if ($change_admin_url === 'on') {
      // Get the new login page
      $new_login_page = home_url('/admin42');

      // If the current request URI is the new login page
      if (strpos($_SERVER['REQUEST_URI'], '/admin42') !== false) {
        // Include the login page template
        echo '<div class="login-form">';
        wp_login_form();
        echo '</div>';
        exit;
      }
    }
  }

  public function redirect_after_login($user_login, $user) {
    // Get the option
    $change_admin_url = get_option('brand42_change_admin_url');

    // If the option is set to true
    if ($change_admin_url === 'on') {
      // Redirect to the new admin URL
      wp_redirect(home_url('/wp-admin'));
      exit;
    }
  }
}