<?php
namespace Brand42\Modules;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Tools Module
 *
 * @package Tools\Modules
 */
class Tools {
  public function __construct() {
    // Add buttons to admin bar
    add_action('admin_bar_menu', [$this, 'add_admin_bar_buttons'], 999);
  }

  public function add_admin_bar_buttons(): void {
    // If WP_Migrate plugin is active, add a button to the admin bar
    if (current_user_can('manage_options') && class_exists('DeliciousBrains\WPMDB\WPMigrateDB')){
      global $wp_admin_bar;
      $wp_admin_bar->add_menu([
        'id' => 'wp-migrate-db-pro',
        'title' => 'WP Migrate',
        'href' => admin_url('admin.php?page=wp-migrate-db-pro'),
        'meta' => [
          'title' => 'WP Migrate'
        ]
      ]);
    }

    // If Elementor plugin is active, add a "Reset Styles" button to the admin bar
    if (current_user_can('manage_options') && class_exists('Elementor\Plugin')){
      global $wp_admin_bar;
      $wp_admin_bar->add_menu([
        'id' => 'brand42-elementor-clear-cache-button',
        'title' => 'Reset CSS',
        'href' => admin_url('admin.php?page=elementor-tools'),
      ]);
    }
  }
}