<?php
namespace Brand42\Modules;

use Elementor\Core\Logger\Items\PHP;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Clean Dashboard Module
 *
 * @package Brand42\Modules\CleanDashboard
 */
class CleanDashboard {
  public function __construct() {

    // Remove dashboard widgets
    add_action('wp_dashboard_setup', [$this, 'remove_dashboard_widgets'], 11);

    // Remove welcome panel
    add_action('admin_init', [$this, 'on_admin_init']);

    // Remove admin bar items
    add_action('wp_before_admin_bar_render', [$this, 'remove_admin_bar_items']);

    // Remove Help tab
    add_action('admin_head', [$this, 'remove_help_tab']);

    // Remove WP branding from footer
    add_filter('admin_footer_text', [$this, 'set_footer_branding']);

    // Add 42 logo to admin bar
    add_action('admin_bar_menu', [$this, 'add_admin_bar_logo'], 0);

    // Add settings
    add_action('brand42_register_settings', [$this, 'add_settings']);

    // Remove ALL actions notice
    add_action('admin_head', [$this, 'remove_action'], 11);
  }

  public function remove_action(): void {
    remove_all_actions('admin_notices');
  }

  public function add_settings($registrar): void {
    $registrar->add_setting(
      [
        'option' => 'brand42_hide_notices',
        'type' => 'switch',
        'label' => 'Masquer les notifications',
        'default' => 'on',
      ]
    );
    $meta_boxes = [
      'dashboard_right_now' => 'Vue d\'ensemble',
      'dashboard_activity' => 'Activité récente',
      'dashboard_quick_press' => 'Brouillon rapide',
      'dashboard_primary' => 'Actualités WordPress',
      'dashboard_secondary' => 'Autres actualités',
      'dashboard_site_health' => 'Santé du site',
      'e-dashboard-overview' => 'Vue d\'ensemble Elementor',
      'wpseo-dashboard-overview' => 'Vue d\'ensemble Yoast SEO',
      'wpseo-wincher-dashboard-overview' => 'Vue d\'ensemble Wincher',
    ];

    $registrar->add_setting(
      [
        'option' => 'brand42_dashboard_widgets',
        'type' => 'checkboxes',
        'label' => 'Widgets du tableau de bord à Afficher',
        'options' => $meta_boxes,
        'default' => $meta_boxes,
      ]
    );
  }

  public function remove_dashboard_widgets(): void {
    /*global $wp_meta_boxes;
    console('meta boxes', $wp_meta_boxes);*/
   //$wp_meta_boxes['dashboard'] = [];

    $meta_boxes = get_option('brand42_dashboard_widgets');
    if ($meta_boxes) {
      foreach ($meta_boxes as $meta_box => $value) {
        remove_meta_box($meta_box, 'dashboard', 'normal');
        remove_meta_box($meta_box, 'dashboard', 'side');
      }
    }
  }

  public function on_admin_init(): void {
    remove_action('welcome_panel', 'wp_welcome_panel');
    global $wp_filter;

    // Remove All notices
    if (isset($wp_filter['admin_notices']) && get_option('brand42_hide_notices') === 'on') {
      unset($wp_filter['admin_notices']);
    }
  }

  public function remove_admin_bar_items(): void {
    global $wp_admin_bar;

    // Remove yoast from admin bar
    $wp_admin_bar->remove_menu('wpseo-menu');

    // Remove comments from admin bar
    $wp_admin_bar->remove_menu('comments');

    // Remove WP logo from admin bar
    $wp_admin_bar->remove_menu('wp-logo');
  }

  public function remove_help_tab(): void {
    $screen = get_current_screen();
    $screen->remove_help_tabs();
  }

  public function set_footer_branding(): string {
    return 'Conçu avec passion par <a href="'.AGENCE42_URL . '" target="_blank" class="brand-link">Agence42</a>.';
  }

  public function add_admin_bar_logo($wp_admin_bar): void {
    $args = [
      'id' => 'brand42-logo',
      'title' => '<svg xmlns="http://www.w3.org/2000/svg" width="250" height="187" viewBox="0 0 25.155 18.814">
    <g id="Groupe_1784" transform="translate(-4596.6 -3104)">
        <path d="M408.012,146.967v-3.609H404v-2.242l3.521-8.216h2.505v8.566h1.559v1.892h-1.559v3.609ZM406,141.449h2.015v-6.044Z" transform="translate(4192.6 2975.847)"></path>
        <path d="M452.1,146.224V144.21l3.521-5.028c.035-.053.14-.193.28-.385s.228-.333.28-.4.123-.193.245-.385a3.067,3.067,0,0,0,.245-.42,3.339,3.339,0,0,0,.175-.4,3.728,3.728,0,0,0,.158-.473c.035-.14.052-.3.088-.491.017-.193.035-.368.035-.578a2.457,2.457,0,0,0-.385-1.419,1.27,1.27,0,0,0-1.121-.578,1.3,1.3,0,0,0-.736.21,1.245,1.245,0,0,0-.473.6,3.738,3.738,0,0,0-.228.788,4.929,4.929,0,0,0-.07.911v.508H452.1v-.508a4.91,4.91,0,0,1,.841-3.066A3.18,3.18,0,0,1,455.6,132a3.373,3.373,0,0,1,2.61.963,3.834,3.834,0,0,1,.911,2.7A5.232,5.232,0,0,1,459,136.87a3.975,3.975,0,0,1-.368,1.086,7.44,7.44,0,0,1-.455.858c-.14.228-.333.508-.578.858l-3.521,4.52h5.028v2.015H452.1Z" transform="translate(4152.926 2976.59)"></path>
        <path d="M503.987,105.8a4.183,4.183,0,1,0,2.962,1.225,4.187,4.187,0,0,0-2.962-1.225m0,7.13a2.938,2.938,0,1,1,2.082-.861,2.943,2.943,0,0,1-2.082.861" transform="translate(4113.582 2998.2)" fill="#00adc4"></path>
        <path d="M515.591,119.284h-.858v-.858a.524.524,0,0,0-.508-.526h-.35a.524.524,0,0,0-.508.526v.858h-.858a.524.524,0,0,0-.508.526v.35a.508.508,0,0,0,.508.508h.858v.858a.524.524,0,0,0,.508.526h.35a.524.524,0,0,0,.508-.526v-.858h.858a.524.524,0,0,0,.526-.508v-.35a.527.527,0,0,0-.526-.526" transform="translate(4103.52 2988.219)" fill="#00adc4"></path>
    </g>
</svg>',
      'href' => AGENCE42_URL,
      'meta' => [
        'class' => 'brand42-logo',
        'target' => '_blank',
      ],
    ];
    $wp_admin_bar->add_node($args);
  }
}