<?php
namespace Brand42\Modules\DashboardWidgets;

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Contact Widget
 *
 * @package Brand42\Modules\DashboardWidgets
 */
abstract class DashboardBaseWidget {
  public function __construct() {
    add_action('wp_dashboard_setup', [$this, 'add_dashboard_widget'], 15);
  }

  public abstract function get_title(): string;
  public abstract function get_name(): string;

  public function get_context(): string {
    return 'normal';
  }

  public function add_dashboard_widget(): void {
    wp_add_dashboard_widget($this->get_name(), $this->get_title(), [$this, 'render_widget'], null, null, $this->get_context());
  }

  public function render_widget(): void {
    $this->render();
  }

  protected abstract function render(): void;
}