<?php
namespace Elementor42\Widgets;

use ElementorPro\Modules\QueryControl\Module as Module_Query;

use ElementorPro\Modules\LoopBuilder\Files\Css\Loop_Dynamic_CSS;
use ElementorPro\Plugin;
use WP_Query;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

trait Loop42RenderTrait {

	/**
	 * @inheritdoc \Elementor\Widget_Base::render()
	 * @return void
	 */
	protected function render(): void {
		$settings = $this->get_settings_for_display();
		//console($settings);
		//TODO: TEST ONLY - TO REMOVE
		//$settings['q_include_term_ids'] = [60];
		$querySettings = $this->_getQueryArgs($settings);

		// TODO: TEST ONLY - TO REMOVE
		/*console($querySettings);
		$querySettings['tax_query'] = [
			[
				'taxonomy' => 'product_cat',
				'field' => 'term_id',
				'terms' => [60],
			]
		];*/

		/*$querySettings['tax_query'][] = [
			[
				'taxonomy' => 'product_cat',
				'field' => 'term_id',
				'terms' => [60],
			]
		];*/

		$query = new \WP_Query($querySettings);

		/*$query_args = [
			'posts_per_page' => $settings['posts_per_page'],
			'orderby' => $settings['q_orderby'],
			'order' => $settings['q_order'],
			'paged' => $settings['pagination_page'],
		];*/

		//$elementor_query = Module_Query::instance();
		//$elemQuery = $elementor_query->get_query( $this, 'posts', $query_args, [] );

		// TODO: Test with Elementor query
		// Elementor query (comment for old query)
		//$query = $elemQuery;



		//console($elemQuery);

		if ($settings['ajax_render'] === true) {
			echo '<main>';
			$this->_printLoopItems($settings, $query);
			echo '</main>';
			if ($settings['show_pagination'] === 'yes') {
				echo '<pagination>';
				echo $this->_getPagination($settings, $query);
				echo '</pagination>';
			}
		} else {
			$this->_printMainWidget($settings, $query);
		}
	}



	/**
	 * Print the main widget
	 *
	 * @param $settings - The settings of the widget
	 * @param $query WP_Query
	 */
	private function _printMainWidget($settings, WP_Query $query): void {
		$this->add_render_attribute('_wrapper',[
			'post-type' => $settings['q_post_type'],
		]);
		$this->add_render_attribute('loop-container', [
			'data-doc-id' => Plugin::elementor()->documents->get_current()->get_id(),
			'data-scroll-offset' => $settings['scroll_to_top_offset'] ?? 0,
			'class' => 'a42-loop42--container',
			'id' => 'a42-loop',
			'data-caching' => $settings['use_ajax_cache'] === 'yes' ? 'true' : 'false',
		]);

		if (!empty($settings['scroll_to_top_offset_tablet'])) {
			$this->add_render_attribute('loop-container', [
				'data-scroll-offset-tablet' => $settings['scroll_to_top_offset_tablet'],
			]);
		}

		if (!empty($settings['scroll_to_top_offset_mobile'])) {
			$this->add_render_attribute('loop-container', [
				'data-scroll-offset-mobile' => $settings['scroll_to_top_offset_mobile'],
			]);
		}

		echo strtr('<div {attributes}>', [
			'{attributes}' => $this->get_render_attribute_string('loop-container'),
		]);

		$this->_printLoopItems($settings, $query);
		echo "</div>";

		if ($settings['show_pagination'] === 'yes') {

			echo '<div class="a42-loop42--pagination flex">';
			//echo 'pagination';
			echo $this->_getPagination($settings, $query);
			echo '</div>';
		}
	}

	/**
	 * Print the pagination
	 * @param $settings
	 * @param $query WP_Query
	 */
	private function _getPagination($settings, WP_Query $query): string {


		$pagesNumber = $query->max_num_pages;
		if ($pagesNumber <= 1) return '';

		$currentPage = max(1, $query->get('paged'));
		if (isset($settings['pagination_page']) && is_numeric($settings['pagination_page']) && $settings['pagination_page'] > 0) {
			$currentPage = (int) $settings['pagination_page'];
		}

		// Pagination as ?page=1
		$pageUrl = !empty($settings['page_url']) ?
			trailingslashit($settings['page_url']) . '%_%'
			: trailingslashit(get_pagenum_link(1)) . '%_%';

		// Force $pageUrl to be site_url/actualites/page/page_number
		$pageUrl = preg_replace('/(\/page\/\d+)+/', '/page/%#%', $pageUrl);

		//echo $pageUrl;
		$pagination = paginate_links([
			'base' => $pageUrl,
			'format' => 'page/%#%',
			'current' => $currentPage,
			'total' => $pagesNumber,
			'type' => 'plain',
			'prev_text' => $settings['pagination_previous_label'],
			'next_text' => $settings['pagination_next_label'],
		]);

		$html = strtr('<nav class="a42-loop42--pagination__nav">{pagination}</nav>', [
			'{pagination}' => $pagination,
		]);

		// Remove params from pagination links
		$html = preg_replace('/\?[^"]+/', '', $html);

		return $html;
	}

	/**
	 * Print the looped items
	 *
	 * @param $settings
	 * @param $query WP_Query
	 */
	private function _printLoopItems($settings, WP_Query $query): void {
		if ($query->have_posts()) {
			while ($query->have_posts()) {
				$query->the_post();
				$this->_printPostItem(get_the_ID(), $settings['template_id']);
			}
		} else {
			$this->_printNoPostsFound($settings['no_posts_found']);
		}
		wp_reset_postdata();
	}

	/**
	 * No posts found
	 * @param $notfound - The text to show
	 * @return void
	 */
	private function _printNoPostsFound($notfound): void {
		echo "<div class='a42-loop42--no-posts-found flex-center flex-grow'>";
		echo "<h2>$notfound</h2>";
		echo "</div>";
	}

	/**
	 * @param $post_id
	 * @param $post_id_for_data
	 *
	 * @return void
	 */
	private function _printPostItem($post_id, $post_id_for_data): void {

		$document = Plugin::elementor()->documents->get_doc_for_frontend( $post_id_for_data );
		if ( ! $document ) {
			return;
		}
		$this->print_dynamic_css( $post_id, $post_id_for_data );
		echo $document->get_content();
	}

	/**
	 * Print dynamic css
	 * @param $post_id
	 * @param $post_id_for_data
	 *
	 * @return void
	 */
	private function print_dynamic_css( $post_id, $post_id_for_data ): void {
		$document = Plugin::elementor()->documents->get_doc_for_frontend( $post_id_for_data );
		if ( ! $document ) {
			return;
		}

		Plugin::elementor()->documents->switch_to_document( $document );

		$css_file = Loop_Dynamic_CSS::create( $post_id, $post_id_for_data );
		$post_css = $css_file->get_content();

		if ( empty( $post_css ) ) {
			return;
		}

		$css = '';
		$css = str_replace( '.elementor-' . $post_id, '.e-loop-item-' . $post_id, $post_css );
		$css = sprintf( '<style id="%s">%s</style>', 'loop-dynamic-' . $post_id_for_data, $css );

		echo $css; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

		Plugin::elementor()->documents->restore_document();
	}
}
