<?php
namespace Elementor42\Modules\ElementorDynamicTags;

use Elementor\Core\DynamicTags\Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class ElementorDynamicTags
 *
 * @package Elementor42\Modules\ElementorDynamicTags
 */
class Module {
	public function run(): void {
		// Check if Elementor Pro is active
		if ( !class_exists('\Elementor\Core\DynamicTags\Tag') ||
		     !class_exists('\ElementorPro\Modules\DynamicTags\Tags\Base\Data_Tag')) {
			return;
		}
		a42_load_directory(__DIR__);
		add_action('elementor/dynamic_tags/register', [$this, 'register_dynamic_tags']);
	}

	/**
	 * Register Dynamic tags
	 *
	 * @param $dynamic_tags_manager Manager
	 * @return void
	 */
	public function register_dynamic_tags(Manager $dynamic_tags_manager): void {
		//$dynamic_tags_manager->register(new HeaderLayoutImage());
		//$dynamic_tags_manager->register(new CustomProfileImage());
		$dynamic_tags_manager->register(new TagFormAction());
	}
}