<?php
/**
 * Class ConditionNoChild
 */

namespace Elementor42\Modules\Conditions;

class ConditionNoChild extends \ElementorPro\Modules\ThemeBuilder\Conditions\Condition_Base {

  public static function get_type(): string {
    return 'singular';
  }

  public static function get_priority(): int {
    return 32;
  }

  public function get_name(): string {
    return 'nochild';
  }

  public function get_label(): ?string {
    return __( '[Agence42] Page sans enfant', 'elementor-pro' );
  }

  public function check( $args ): bool {
    // Get the current post
    $post = get_post();
    if ( ! is_singular() || empty($post) || (!empty($post) && $post->post_type !== 'page') ) {
      return false;
    } else {
      $children = get_children( array(
        'post_parent' => $post->ID,
        'post_type'   => $post->post_type
      ) );
      return empty( $children );
    }
  }
}