<?php

namespace Elementor42\Modules\Ajax;

use Elementor42\CityManager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Form Fields Module
 *
 * @package Elementor42\Modules\Ajax
 */
class Module {

	/**
	 * @var CityManager
	 */
	private CityManager $cityManager;

	public function __construct() {
		$this->cityManager = CityManager::getInstance();
		add_action( 'wp_ajax_a42_city_autocomplete', [ $this, 'a42_city_autocomplete' ] );
		add_action( 'wp_ajax_nopriv_a42_city_autocomplete', [ $this, 'a42_city_autocomplete' ] );
	}


	/**
	 * Ajax call for the a42 city autocomplete widget
	 */
	public function a42_city_autocomplete(): void {
		$cities = $this->cityManager->getCities();
		if ( ! $cities ) {
			wp_send_json_error('No cities found');
		}
		wp_send_json_success($cities);
	}
}

