<?php
namespace Elementor42\Includes\ComponentModifiers;


if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
}

/**
 * Class Form
 */
class Form {

	public function __construct() {
		// Add controls to widget
		add_action('elementor/element/form/section_form_fields/before_section_end', [$this, 'add_controls'], 10, 2);

		// Add class css to widget form
		add_action('elementor/frontend/widget/before_render', [$this, 'render'], 10, 1);

		// Add Assets
		add_action('elementor/frontend/after_enqueue_styles', [$this, 'enqueue_css']);
		add_action('elementor/frontend/after_enqueue_scripts', [$this, 'enqueue_js'], 100, 1);
	}

	/**
	 * Add controls to widget
	 * @param $element
	 * @param $args
	 * @return void
	 */
	public function add_controls($element, $args): void {
		// Is step carousel form ?
		$element->add_control(
			'is_step_carousel',
			[
				'label' => __('Etapes en carousel', ELEMENTOR42_SLUG),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Oui', 'elementor42'),
				'label_off' => __('Non', 'elementor42'),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',
			]
		);

		// Use Elementor 42 to manage validations (grey button) ?
		$element->add_control(
			'is_elementor42_validation',
			[
				'label' => __('Utiliser les validations Elementor42', ELEMENTOR42_SLUG),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Oui', 'elementor42'),
				'label_off' => __('Non', 'elementor42'),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',
			]
		);
	}

	/**
	 * Add class css to widget form
	 * @param $widget
	 * @return void
	 */
	public function render($widget): void {
		if ($widget->get_name() !== 'form') {
			return;
		}

		if ($widget->get_settings('is_step_carousel') === 'yes') {
			$widget->add_render_attribute('_wrapper', 'class', 'step-carousel');
		}

		if ($widget->get_settings('is_elementor42_validation') === 'yes') {
			$widget->add_render_attribute('_wrapper', 'class', 'elementor42-validation');
		}
	}

	public function enqueue_css(): void {
		wp_enqueue_style('elementor42-form', ELEMENTOR42_ASSETS . '/css/customized-widgets/form.css', [], ELEMENTOR42_VERSION);
	}

	public function enqueue_js(): void {
		wp_enqueue_script('elementor42-form', ELEMENTOR42_ASSETS . '/js/customized-widgets/form.js', [], ELEMENTOR42_VERSION, true);
	}
}