<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.agence42.fr
 * @since             1.0.0
 * @package           Elementor42
 *
 * @wordpress-plugin
 * Plugin Name:       Elementor42
 * Plugin URI:        https://www.agence42.fr
 * Description:       Overloads the Elementor plugin for simpler use
 * Version:           1.3.0
 * Author:            SAHEB-JAMII Soheil
 * Author URI:        https://anym.fr
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       elementor-menu42
 * Domain Path:       /languages
 */

// If this file is called directly, abort.

if ( ! defined( 'WPINC' ) ) {
  die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
const ELEMENTOR42_VERSION = '1.3.0';
const ELEMENTOR42_SLUG = 'elementor42';
define('ELEMENTOR42_URL', plugin_dir_url(__FILE__));
define('ELEMENTOR42_DIR', plugin_dir_path(__FILE__));
const ELEMENTOR42_ASSETS = ELEMENTOR42_URL . 'assets';

require_once "includes/class-update-checker.php";
new Elementor42\Includes\UpdateChecker();

/**
 * Load the plugin
 */
function run_elementor42(): void {
  /**
   * Register CSS
   */
  add_action('wp_enqueue_scripts', function() {
    wp_enqueue_style('elementor42', ELEMENTOR42_URL . 'assets/css/global/elementor42.css', [], ELEMENTOR42_VERSION);
  });

  /**
   * Load modules
   */
  require_once ELEMENTOR42_DIR . './includes/component-modifier.php';
  new \Elementor42\Includes\ComponentModifier();

	require_once ELEMENTOR42_DIR . './includes/city-manager.php';
}

/**
 * Load all files in a directory via pattern
 * @param string $directory - The directory to load
 * @param array $pattern - The pattern to load
 * @return void
 */
if (!function_exists('a42_load_directory')) {
	function a42_load_directory(string $directory, array $pattern = ['/*/trait-*.php', '/*/interface-*.php', '/*/class-*.php']): void {
		// For each pattern
		foreach ($pattern as $p) {
			$files = glob($directory . $p);
			foreach ($files as $file) {
				require_once $file;
			}
		}
	}
}

//run_elementor42();
add_action('plugins_loaded', 'run_elementor42');

// Add Elementor category
add_action('elementor/elements/categories_registered', function($elements_manager) {
	$elements_manager->add_category(
		'agency42',
		[
			'title' => __('Agence42', 'agency42'),
			'icon' => 'fa fa-plug',
		]
	);
});

// Elementor widgets
add_action('elementor/init', function() {
	require_once ELEMENTOR42_DIR . '/utils/elementor-functions.php';
	require_once ELEMENTOR42_DIR . '/utils/class-base-widget.php';

	a42_load_directory(ELEMENTOR42_DIR . '/widgets');


	// Add elementor custom form fields
	require_once ELEMENTOR42_DIR . '/modules/elementor-form-fields/module.php';
	$module_elementor_form_fields = new Elementor42\Modules\ElementorFormFields\Module();
	$module_elementor_form_fields->run();

	// Add elementor custom form actions
	require_once ELEMENTOR42_DIR . '/modules/elementor-form-actions/module.php';
	$module_elementor_form_actions = new Elementor42\Modules\ElementorFormActions\Module();
	$module_elementor_form_actions->run();

	// Add elementor custom dynamic tags
	require_once ELEMENTOR42_DIR . '/modules/elementor-dynamic-tags/module.php';
	$module_elementor_dynamic_tags = new Elementor42\Modules\ElementorDynamicTags\Module();
	$module_elementor_dynamic_tags->run();

	require_once ELEMENTOR42_DIR . '/modules/ajax/module.php';
	new \Elementor42\Modules\Ajax\Module();


	new \Elementor42\Widgets\Loop42Ajax();

	// Elementor modifications
	new \Elementor42\Widgets\OptionFlexBasis();

	// Elementor widgets
	add_action('elementor/widgets/register', function($widgets_manager) {
		$widgets_manager->register(new \Elementor42\Widgets\Title());
		//$widgets_manager->register_widget_type(new \Elementor42\Widgets\Cta());
		$widgets_manager->register(new \Elementor42\Widgets\Loop42());
		$widgets_manager->register(new \Elementor42\Widgets\LoopFilter42());
		$widgets_manager->register(new \Elementor42\Widgets\AdvancedLoopFilter42());
		$widgets_manager->register(new \Elementor42\Widgets\ScrollTopBtn());

		// If WooCommerce is active
		if (class_exists('WooCommerce')) {
			$widgets_manager->register(new \Elementor42\Widgets\WooProductMeta());
		}
	});

	// Elementor modules
	require_once ELEMENTOR42_DIR . '/modules/class-template-conditions.php';
	new \Elementor42\Modules\TemplateConditions();

	// Do Action Elementor42 Loaded
	do_action('elementor42/loaded');

});

/**
 * Console log for debug
 */
if( !function_exists('console') ) {
  function console($output, $with_script_tags = true): void {
    $js_code = 'console.log(' . json_encode($output, JSON_HEX_TAG) . ');';
    if ($with_script_tags) {
      $js_code = '<script>' . $js_code . '</script>';
    }
    echo $js_code;
  }
}


