<?php
namespace Elementor42\Widgets;;

use function Elementor42\Utils\getCssColor;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait CtaRenderTrait {

  /**
   * @inheritdoc \Elementor\Widget_Base::render()
   */
  protected function render(): void {
    $settings = $this->get_settings_for_display();
    $this->render_output($settings);
  }

  /**
   * Render content
   * If for example 2 keys are type h1, then 2 h1 will be rendered as only one.
   */
  protected function render_output(array $settings): void {
    $items = $settings['content'];
    $is_link = !empty($settings['link']['url']);
    $this->add_render_attribute('cta-wrapper', 'class', 'a42-cta-wrapper');
    if ($is_link) {
      $this->add_render_attribute('cta-wrapper', 'href', $settings['link']['url']);
      $this->add_render_attribute('cta-wrapper', 'target', $settings['link']['is_external'] ? '_blank' : '_self');
    }
    echo sprintf('<%s %s>', $is_link ? 'div' : 'div', $this->get_render_attribute_string('cta-wrapper'));
    foreach ($items as $index => $item) {
      switch ($item['type']) {
        case 'title':
          $this->_render_title($item, $index);
          break;
        case 'text':
          $this->_render_text($item, $index);
          break;
        case 'button':
          $this->_render_button($item, $index);
          break;
        case 'image':
          $this->_render_image($item, $index);
          break;
        case 'divider':
          $this->_render_divider($item, $index);
          break;
        case 'icon':
          $this->_render_icon($item, $index);
          break;
        case 'html':
          $this->_render_html($item, $index);
          break;
        default:
          break;
      }
    }
    echo sprintf('</%s>', $is_link ? 'a' : 'div');
  }

  /** ********************
   * Render title
   * *********************/
  private function _render_title($item, $index): void {
    $type = $item['title_type'];
    $classname = !empty($item['classname']) ? ' ' . $item['classname'] : '';
    if ($type === 'h1' || $type === 'h2' || $type === 'h3' || $type === 'h4' || $type === 'h5' || $type === 'h6') {
      echo sprintf('<%s class="cta-title cta-hn-title%s">%s</%s>', $type, $classname, $item['title'], $type);
    } else {
      echo sprintf('<div class="%s cta-title%s">%s</div>', 'cta-'.$type, $classname, $item['title']);
    }
  }

  /** ********************
   * Render text
   * *********************/
  private function _render_text($item, $index): void {
    $classname = !empty($item['classname']) ? ' ' . $item['classname'] : '';
    echo sprintf('<div class="cta-text%s">%s</div>', $classname, $item['text']);
  }

  /** ********************
   * Render button
   * *********************/
  private function _render_button($item, $index): void {
    $is_link = !empty($item['link']['url']);
    if (!empty($item['classname'])) {
      $classes = explode(' ', $item['classname']);
      $this->add_render_attribute('button_' . $index, 'class', $classes);
    }
    $this->add_render_attribute('button_' . $index, 'class', ['cta-button-' . $item['button_type'], 'cta-button', 'flex', 'align-center', 'gap-20']);
    if ($item['button_icon_before'] === 'yes') {
      $this->add_render_attribute('button_' . $index, 'class', 'cta-button-icon-before flex-reverse');
    }
    echo sprintf('<%s %s>',
      $is_link ? 'a' : 'div', $this->get_render_attribute_string('button_' . $index));
    if (!empty($item['button_icon']) && $item['button_icon_before'] === 'yes') {
      $this->render_icon($item['button_icon'], $index);
    }
    echo $item['button_text'];

    if (!empty($item['button_icon']) && $item['button_icon_before'] !== 'yes') {
      $this->render_icon($item['button_icon'], $index);
    }
    echo sprintf('</%s>', $is_link ? 'a' : 'div');
  }

  /** ********************
   * Render image
   * *********************/
  private function _render_image($item, $index) {

  }

  /** ********************
   * Render divider
   * *********************/
  private function _render_divider($item, $index): void {
    $classname = !empty($item['classname']) ? ' ' . $item['classname'] : '';
    echo '<div class="cta-divider'.$classname.'"></div>';
  }

  /** ********************
   * Render icon
   * *********************/
  private function _render_icon($item, $index): void {
    if (!empty($item['classname'])) {
      echo '<div class="cta-icon-wrapper '.$item['classname'].'">';
    }
    $this->render_icon($item['icon'], 'cta-icon');
    if (!empty($item['classname'])) {
      echo '</div>';
    }
  }

  /** ********************
   * Render html
   * *********************/
  private function _render_html($item, $index): void {
    $classname = !empty($item['classname']) ? ' ' . $item['classname'] : '';

    $html = $item['html'] ?? '';
    echo '<div class="cta-html'.$classname.'">{$html}</div>';
  }

}