<?php
namespace Elementor42\Widgets;;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

trait CtaContentTrait {

  private function register_controls_content(): void {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __( 'Éléments', ELEMENTOR42_SLUG ),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    /**
     * Repeater title
     * Can add as many fields as needed
     * Can choose Pre Title, Title, Subtitle
     */
    $content_repeater = new \Elementor\Repeater();
    $content_repeater->add_control(
      'type',
      [
        'label' => __( 'Type', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
          'icon' => [
            'title' => __( 'Icône', ELEMENTOR42_SLUG ),
            'icon' => 'fa fa-icons',
          ],
          'title' => [
            'title' => __( 'Titre', ELEMENTOR42_SLUG ),
            'icon' => 'fa fa-heading',
          ],
          'text' => [
            'title' => __( 'Texte', ELEMENTOR42_SLUG ),
            'icon' => 'fa fa-paragraph',
          ],
          /*'image' => [
            'title' => __( 'Image', ELEMENTOR42_SLUG ),
            'icon' => 'fa fa-image',
          ],*/
          'button' => [
            'title' => __( 'Bouton', ELEMENTOR42_SLUG ),
            'icon' => 'fa fa-link',
          ],
          'divider' => [
            'title' => __( 'Séparateur', ELEMENTOR42_SLUG ),
            'icon' => 'fa fa-minus',
          ],
          'html' => [
            'title' => __( 'HTML', ELEMENTOR42_SLUG ),
            'icon' => 'fa fa-code',
          ],
        ],
        'default' => 'text',
        'toggle' => false,
      ]
    );

    /** *****************************************************
     * Case Icon
     * *****************************************************/
    $content_repeater->add_control(
      'icon',
      [
        'label' => __( 'Icône', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-chevron-right',
          'library' => 'solid',
        ],
        'condition' => [
          'type' => 'icon',
        ],
      ]);

    /** *****************************************************
     * Case Title
     * ******************************************************/
    $content_repeater->add_control(
      'title',
      [
        'label' => __( 'Titre', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::TEXTAREA,
        'dynamic' => [
          'active' => true,
        ],
        'default' => __( 'Lorem ipsum dolor', ELEMENTOR42_SLUG ),
        'placeholder' => __( 'Entrez votre titre', ELEMENTOR42_SLUG ),
        'condition' => [
          'type' => 'title',
        ],
      ]
    );
    $content_repeater->add_control(
      'title_type',
      [
        'label' => __( 'Type de titre', 'a42' ),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'h1' => __( 'Titre H1', ELEMENTOR42_SLUG ),
          'h2' => __( 'Titre H2', ELEMENTOR42_SLUG ),
          'h3' => __( 'Titre H3', ELEMENTOR42_SLUG ),
          'h4' => __( 'Titre H4', ELEMENTOR42_SLUG ),
          'h5' => __( 'Titre H5', ELEMENTOR42_SLUG ),
          'h6' => __( 'Titre H6', ELEMENTOR42_SLUG ),
          'custom_title' => __( 'Div (Titre custom)', ELEMENTOR42_SLUG ),
          'pre_title' => __( 'Pré Titre', ELEMENTOR42_SLUG ),
          'sub_title' => __( 'Sous Titre', ELEMENTOR42_SLUG ),
        ],
        'default' => 'h5',
        'condition' => [
          'type' => 'title',
        ],
      ]
    );

    /** *****************************************************
     * Case Text
     * ******************************************************/
    $content_repeater->add_control(
      'text',
      [
        'label' => __( 'Texte', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::TEXTAREA,
        'dynamic' => [
          'active' => true,
        ],
        'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed non risus. Suspendisse lectus tortor, dignissim sit amet, adipiscing nec, ultricies sed, dolor.', ELEMENTOR42_SLUG ),
        'placeholder' => __( 'Entrez votre texte', ELEMENTOR42_SLUG ),
        'condition' => [
          'type' => 'text',
        ],
      ]
    );

    /** *****************************************************
     * Case Image
     * ******************************************************/
    /*$content_repeater->add_control(
      'image',
      [
        'label' => __( 'Image', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'type' => 'image',
        ],
      ]
    );*/

    /** *****************************************************
     * Case Button
     * ******************************************************/
    $content_repeater->add_control(
      'button_text',
      [
        'label' => __( 'Texte du bouton', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::TEXT,
        'default' => __( 'Lorem ipsum', ELEMENTOR42_SLUG ),
        'placeholder' => __( 'Entrez votre texte', ELEMENTOR42_SLUG ),
        'condition' => [
          'type' => 'button',
        ],
      ]
    );
    $content_repeater->add_control(
      'button_link',
      [
        'label' => __( 'Lien du bouton', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::URL,
        'placeholder' => __( 'https://votrelien.com', ELEMENTOR42_SLUG ),
        'default' => [
          'url' => '#',
        ],
        'condition' => [
          'type' => 'button',
        ],
      ]
    );
    $content_repeater->add_control(
      'button_type',
      [
        'label' => __( 'Type de bouton', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::SELECT,
        'default' => 'primary',
        'options' => [
          'primary' => __( 'Primaire', ELEMENTOR42_SLUG ),
          'secondary' => __( 'Secondaire', ELEMENTOR42_SLUG ),
          'tertiary' => __( 'Tertiaire', ELEMENTOR42_SLUG ),
        ],
        'condition' => [
          'type' => 'button',
        ],
      ]
    );
    $content_repeater->add_control(
      'button_icon',
      [
        'label' => __( 'Icône du bouton', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-chevron-right',
          'library' => 'solid',
        ],
        'condition' => [
          'type' => 'button',
        ],
      ]
    );
    // Icon before ?
    $content_repeater->add_control(
      'button_icon_before',
      [
        'label' => __( 'Icône avant le bouton', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'return_value' => 'yes',

        'condition' => [
          'type' => 'button',
        ],
      ]
    );

    /** *****************************************************
     * Case Separator
     * ******************************************************/
    // Nothing to do

    /** *****************************************************
     * Case HTML
     * ******************************************************/
    $content_repeater->add_control(
      'html',
      [
        'label' => __( 'HTML', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::CODE,
        'language' => 'html',
        'rows' => 10,
        'placeholder' => __( 'Entrez votre code HTML', ELEMENTOR42_SLUG ),
        'condition' => [
          'type' => 'html',
        ],
      ]
    );

    /** *****************************************************
     * Global
     * ******************************************************/
    $content_repeater->add_control(
      'classname',
      [
        'label' => __( 'Classe css', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::TEXT,
        'default' => '',
      ]
    );


    /**
     * Add the repeater to the content
     */
    $this->add_control(
      'content',
      [
        'label' => __( 'Contenu', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::REPEATER,
        'fields' => $content_repeater->get_controls(),
        'default' => [
          [
            'type' => 'text',
          ],
        ],
        'title_field' => '{{{ type }}}',
      ]
    );

    $this->end_controls_section();

    /**
     * Add Link settings
     */
    $this->start_controls_section(
      'section_link',
      [
        'label' => __( 'Lien', ELEMENTOR42_SLUG ),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'link',
      [
        'label' => __( 'Lien', ELEMENTOR42_SLUG ),
        'type' => Controls_Manager::URL,
        'placeholder' => __( 'https://votrelien.com', ELEMENTOR42_SLUG ),
      ]
    );

    $this->end_controls_section();


  }
}