


class Acceptance {
    constructor(element) {
        this.element = element;
        this.element.Acceptance = this;
        this.element.RadioButtons = this;
        this.validationElement = this.element;
        if (this.validationElement == null) {
            return;
        }
        this.init();
    }

    init() {
        this.validationElement.getValidity = this.getValidity.bind(this);

        // When user selects a radio button, the validation element will dispatch a change event
        this.element.addEventListener('change', this.change.bind(this));
        this.element.addEventListener('showError', _ => {
            if (this.validationElement.error != null) {
                this.setError();
            }

        });
    }

    getValidity() {
        const isFieldRequired = this.element.getAttribute('a42required') === 'required';
        if (isFieldRequired) {
            const checked = this.isChecked();
            if (!checked) {
                this.validationElement.error = 'Veuillez accepter les conditions';
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }

    isChecked() {
        return this.element.checked;
    }

    setError() {
        this.element.setAttribute('aria-invalid', 'true');
        this.element.closest('.elementor-field-option').classList.add('elementor-error');
    }

    unsetError() {
        this.validationElement.error = '';
        this.element.setAttribute('aria-invalid', 'false');
        this.element.closest('.elementor-field-option').classList.remove('elementor-error');
    }

    change() {
        if (this.getValidity() === true) {
            this.validationElement.dispatchEvent(new Event('removeError'));
            this.unsetError();
        } else {
            this.validationElement.dispatchEvent(new Event('showError'));
            this.setError();
        }
    }
}

window.addEventListener('elementor/frontend/init', () => {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', function($scope) {
        $scope.find('input.elementor-acceptance-field').each(function() {
            if(this.Acceptance) return;
            new Acceptance(this);
        });
    });
});