

class AdvancedLoopFilter42 {
    get activeFilters() {
        const filters = [];
        this.element.querySelectorAll('select').forEach(select => {
            const values = [];
            const id = select.dataset.taxonomy;

            Array.from(select.selectedOptions).forEach(option => {
                if (option.value !== '') {
                    values.push(option.value);
                }
            });

            if (values.length > 0) {
                filters.push({
                    taxonomy: id,
                    value: values
                });
            }
        });

        return filters;
    }
    constructor(element) {
        this.element = element;
        this.element.AdvancedLoopFilter42 = this;
        this.Loop42 = document.querySelector('.elementor-widget-a42-loop42')?.Loop42;
        this.init();
    }

    init() {
        this.element.querySelectorAll('select').forEach(select => {
            select.addEventListener('change', this.change.bind(this));
            select.addEventListener('value', this.change.bind(this));
        });
    }

    change(e) {
        this.fetchData();
    }

    fetchData() {
        const args = {advanced_filters: this.activeFilters};
        this.Loop42?.query(args);
    }
}

window.addEventListener('elementor/frontend/init', () => {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', function($scope) {
        // If scope has class 'elementor-widget-a42-loop42' then initialize AdvancedLoopFilter42
        if ($scope.hasClass('elementor-widget-a42-advanced-loop-filter42')) {
            const element = $scope[0];
            if (element.AdvancedLoopFilter42 != null) {
                return;
            }
            new AdvancedLoopFilter42(element);
        }
    });
});